/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.reactor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jvnet.hudson.reactor.Milestone;
import org.jvnet.hudson.reactor.ReactorException;
import org.jvnet.hudson.reactor.ReactorListener;
import org.jvnet.hudson.reactor.Task;
import org.jvnet.hudson.reactor.TaskBuilder;
import org.jvnet.hudson.reactor.TunnelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reactor
implements Iterable<Node> {
    private final Set<Node> tasks = new HashSet<Node>();
    private int pending = 0;
    private TunnelException fatal;
    private final Map<Milestone, Node> milestones = new HashMap<Milestone, Node>();
    private Executor executor;
    private ReactorListener listener;
    private boolean executed = false;

    public Reactor(Collection<? extends TaskBuilder> builders) throws IOException {
        for (TaskBuilder taskBuilder : builders) {
            for (Task task : taskBuilder.discoverTasks(this)) {
                this.add(task);
            }
        }
    }

    public Reactor(TaskBuilder ... builders) throws IOException {
        this(Arrays.asList(builders));
    }

    @Override
    public Iterator<Node> iterator() {
        return this.tasks.iterator();
    }

    public int size() {
        return this.tasks.size();
    }

    public void execute(Executor e) throws InterruptedException, ReactorException {
        this.execute(e, ReactorListener.NOOP);
    }

    private synchronized Node milestone(final Milestone m) {
        Node n = this.milestones.get(m);
        if (n == null) {
            n = new Node(new Runnable(){

                public void run() {
                    Reactor.this.listener.onAttained(m);
                }

                public String toString() {
                    return "Milestone:" + m.toString();
                }
            });
            this.milestones.put(m, n);
        }
        return n;
    }

    public void add(Task t) {
        this.addAll(Collections.singleton(t));
    }

    public synchronized void addAll(Iterable<? extends Task> _tasks) {
        ArrayList<Node> newNodes = new ArrayList<Node>();
        for (final Task task : _tasks) {
            Node n = new Node(new Runnable(){

                public void run() {
                    block2: {
                        Reactor.this.listener.onTaskStarted(task);
                        try {
                            Reactor.this.runTask(task);
                            Reactor.this.listener.onTaskCompleted(task);
                        }
                        catch (Throwable x) {
                            boolean fatal = task.failureIsFatal();
                            Reactor.this.listener.onTaskFailed(task, x, fatal);
                            if (!fatal) break block2;
                            throw new TunnelException(x);
                        }
                    }
                }

                public String toString() {
                    return "Task:" + task.getDisplayName();
                }
            });
            for (Milestone milestone : task.requires()) {
                n.addPrerequisite(this.milestone(milestone));
            }
            for (Milestone milestone : task.attains()) {
                this.milestone(milestone).addPrerequisite(n);
            }
            this.tasks.add(n);
            newNodes.add(n);
        }
        for (Node node : newNodes) {
            node.runIfPossible();
        }
        for (Node node : this.milestones.values()) {
            node.runIfPossible();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(Executor e, ReactorListener listener) throws InterruptedException, ReactorException {
        if (this.executed) {
            throw new IllegalStateException("This session is already executed");
        }
        this.executed = true;
        this.executor = e;
        this.listener = listener;
        try {
            for (Node n : this.tasks) {
                n.runIfPossible();
            }
            for (Node n : this.milestones.values()) {
                n.runIfPossible();
            }
            while (this.pending > 0) {
                this.wait();
                if (this.fatal == null) continue;
                throw new ReactorException(this.fatal.getCause());
            }
        }
        finally {
            this.executor = null;
            this.listener = null;
        }
    }

    protected void runTask(Task t) throws Exception {
        t.run(this);
    }

    final class Node
    implements Runnable {
        private final Set<Node> prerequisites = new HashSet<Node>();
        private final Runnable task;
        private final Set<Node> downstream = new HashSet<Node>();
        private boolean submitted;
        private boolean done;

        private Node(Runnable task) {
            this.task = task;
        }

        private void addPrerequisite(Node n) {
            this.prerequisites.add(n);
            n.downstream.add(this);
        }

        private boolean canRun() {
            if (this.submitted || Reactor.this.executor == null) {
                return false;
            }
            for (Node n : this.prerequisites) {
                if (n.done) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.task.run();
            }
            catch (TunnelException t) {
                Reactor.this.fatal = t;
            }
            finally {
                this.done = true;
            }
            Reactor reactor = Reactor.this;
            synchronized (reactor) {
                if (Reactor.this.fatal == null) {
                    for (Node n : this.downstream) {
                        n.runIfPossible();
                    }
                }
                Reactor.this.pending--;
                Reactor.this.notify();
            }
        }

        public void runIfPossible() {
            if (!this.canRun()) {
                return;
            }
            Reactor.this.pending++;
            this.submitted = true;
            Reactor.this.executor.execute(this);
        }

        public String toString() {
            return this.task.toString();
        }
    }
}

