/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.deploy.weblogic.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.hudsonci.plugins.deploy.weblogic.data.TransfertConfiguration;
import org.hudsonci.plugins.deploy.weblogic.exception.TransfertFileException;

public class FTPUtils {
    public static final void transfertFile(TransfertConfiguration transfertConfiguration, PrintStream log) throws TransfertFileException {
        FTPClient ftpClient = new FTPClient();
        FileInputStream localFileToTransfert = null;
        try {
            ftpClient.setConnectTimeout(20000);
            ftpClient.connect(transfertConfiguration.getHost());
            int reply = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                throw new TransfertFileException("FTP SERVER REFUSED CONNECTION. ERROR CODE = " + reply);
            }
            if (!ftpClient.login(transfertConfiguration.getUser(), transfertConfiguration.getPassword())) {
                throw new TransfertFileException("Failed to login to FTP");
            }
            if (!ftpClient.setFileType(2)) {
                throw new TransfertFileException("Unable to set the file type to BINARY");
            }
            localFileToTransfert = new FileInputStream(transfertConfiguration.getLocalFilePath());
            if (!ftpClient.storeFile(transfertConfiguration.getRemoteFilePath(), (InputStream)localFileToTransfert)) {
                throw new TransfertFileException("Unable to transfert file " + transfertConfiguration.getLocalFilePath() + " on " + transfertConfiguration.getHost());
            }
            ftpClient.disconnect();
        }
        catch (Exception e) {
            try {
                throw new TransfertFileException("Failed to download file completely", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(localFileToTransfert);
                if (ftpClient.isConnected()) {
                    try {
                        ftpClient.disconnect();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)localFileToTransfert);
        if (ftpClient.isConnected()) {
            try {
                ftpClient.disconnect();
            }
            catch (IOException ioe) {}
        }
    }
}

