/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.deploy.weblogic.deployer;

import hudson.model.Run;
import hudson.remoting.Callable;
import hudson.remoting.Which;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.hudsonci.plugins.deploy.weblogic.deployer.WebLogicCommand;
import org.hudsonci.plugins.deploy.weblogic.deployer.WebLogicDeployerParameters;

public class WebLogicDeployer {
    private static final String WEBLOGIC_TOOL_DEPLOYER_MAIN_CLASS = "weblogic.Deployer";

    public static final String[] getWebLogicCommandLine(WebLogicDeployerParameters parameter) {
        String targetedDeploymentName;
        ArgumentListBuilder args = new ArgumentListBuilder();
        if (parameter.getUsedJdk() == null) {
            args.add("java");
        } else {
            args.add(parameter.getBuild().getProject().getJDK().getExecutable());
        }
        if (StringUtils.isNotBlank((String)parameter.getJavaOpts())) {
            String[] javaOptions = StringUtils.split((String)parameter.getJavaOpts(), (char)' ');
            args.add(javaOptions);
        }
        args.add("-cp");
        String remotingJar = null;
        if (StringUtils.isNotBlank((String)parameter.getClasspath())) {
            remotingJar = parameter.getClasspath();
        } else {
            try {
                remotingJar = (String)parameter.getLauncher().getChannel().call((Callable)new GetRemotingJar());
            }
            catch (Exception e) {
                parameter.getListener().error("Failed to determine the location of weblogic-9.2.jar");
                throw new Run.RunnerAbortedException();
            }
            if (remotingJar == null) {
                parameter.getListener().error("Failed to determine the location of weblogic-9.2.jar");
                throw new Run.RunnerAbortedException();
            }
        }
        args.add(remotingJar);
        args.add(WEBLOGIC_TOOL_DEPLOYER_MAIN_CLASS);
        args.add("-debug");
        if (!WebLogicCommand.UNDEPLOY.equals((Object)parameter.getCommand()) && !parameter.isLibrary()) {
            args.add("-stage");
        }
        args.add("-remote");
        args.add("-verbose");
        if (!WebLogicCommand.UNDEPLOY.equals((Object)parameter.getCommand()) && !parameter.isLibrary()) {
            args.add("-upload");
        }
        if (parameter.isSilentMode()) {
            args.add("-noexit");
        }
        args.add("-name");
        String string = targetedDeploymentName = StringUtils.isNotBlank((String)parameter.getDeploymentName()) ? parameter.getDeploymentName() : parameter.getArtifactName();
        if (StringUtils.isBlank((String)targetedDeploymentName)) {
            // empty if block
        }
        args.add(targetedDeploymentName);
        if (StringUtils.isNotBlank((String)parameter.getSource())) {
            args.add("-source");
            args.add(parameter.getSource());
        }
        args.add("-targets");
        args.add(parameter.getDeploymentTargets());
        args.add("-adminurl");
        args.add("t3://" + parameter.getEnvironment().getHost() + ":" + parameter.getEnvironment().getPort());
        args.add("-user");
        args.add(parameter.getEnvironment().getLogin());
        args.add("-password");
        args.add(parameter.getEnvironment().getPassword());
        args.add("-" + parameter.getCommand().getValue());
        if (parameter.isLibrary()) {
            args.add("-library");
        }
        return args.toCommandArray();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static final class GetRemotingJar
    implements Callable<String, IOException> {
        private static final long serialVersionUID = 4132805045587298491L;

        public String call() throws IOException {
            Class<?> classReference = null;
            try {
                classReference = Class.forName(WebLogicDeployer.WEBLOGIC_TOOL_DEPLOYER_MAIN_CLASS);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return Which.jarFile(classReference).getPath();
        }
    }
}

