/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.analysis.util.PackageDetectors;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.warnings.parser.AbstractWarningsParser;
import hudson.plugins.warnings.parser.ParsingCanceledException;
import hudson.plugins.warnings.parser.Warning;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jvnet.localizer.Localizable;

@Deprecated
public abstract class RegexpParser
extends AbstractWarningsParser {
    private static final long serialVersionUID = -82635675595933170L;
    protected static final Warning FALSE_POSITIVE = new Warning("", 0, "", "", "");
    protected static final String DEPRECATION = "Deprecation";
    protected static final String PROPRIETARY_API = "Proprietary API";
    protected static final String ANT_TASK = "^(?:.*\\[.*\\])?\\s*";
    private Pattern pattern;

    public String getName() {
        return this.getGroup();
    }

    private void setPattern(String warningPattern, boolean useMultiLine) {
        this.pattern = useMultiLine ? Pattern.compile(warningPattern, 8) : Pattern.compile(warningPattern);
    }

    public RegexpParser(Localizable parserName, Localizable linkName, Localizable trendName, String warningPattern, boolean useMultiLine) {
        super(parserName, linkName, trendName);
        this.setPattern(warningPattern, useMultiLine);
    }

    protected void findAnnotations(String content, List<FileAnnotation> warnings) throws ParsingCanceledException {
        Matcher matcher = this.pattern.matcher(content);
        while (matcher.find()) {
            Warning warning = this.createWarning(matcher);
            if (warning != FALSE_POSITIVE) {
                this.detectPackageName(warning);
                warnings.add((FileAnnotation)warning);
            }
            if (!Thread.interrupted()) continue;
            throw new ParsingCanceledException();
        }
    }

    private void detectPackageName(Warning warning) {
        if (!warning.hasPackageName()) {
            warning.setPackageName(PackageDetectors.detectPackageName((String)warning.getFileName()));
        }
    }

    protected abstract Warning createWarning(Matcher var1);

    protected String classifyWarning(String message) {
        if (StringUtils.contains((String)message, (String)"proprietary")) {
            return PROPRIETARY_API;
        }
        if (StringUtils.contains((String)message, (String)"deprecated")) {
            return DEPRECATION;
        }
        return "";
    }

    protected String classifyIfEmpty(String group, String message) {
        String category = StringUtils.capitalize((String)group);
        if (StringUtils.isEmpty((String)category)) {
            category = this.classifyWarning(message);
        }
        return category;
    }

    @Deprecated
    public RegexpParser(String warningPattern, String name) {
        this(warningPattern, false, name);
    }

    @Deprecated
    public RegexpParser(String warningPattern, boolean useMultiLine, String name) {
        super(name);
        this.setPattern(warningPattern, useMultiLine);
    }
}

