/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.AnnotationsClassifier;
import hudson.plugins.analysis.core.BuildHistory;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwarePublisher;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.NullBuildHistory;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.ModuleDetector;
import hudson.plugins.analysis.util.NullModuleDetector;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.warnings.AggregatedWarningsResult;
import hudson.plugins.warnings.AggregatedWarningsResultAction;
import hudson.plugins.warnings.ConsoleParser;
import hudson.plugins.warnings.ParserConfiguration;
import hudson.plugins.warnings.WarningsAnnotationsAggregator;
import hudson.plugins.warnings.WarningsBuildHistory;
import hudson.plugins.warnings.WarningsDescriptor;
import hudson.plugins.warnings.WarningsResult;
import hudson.plugins.warnings.WarningsResultAction;
import hudson.plugins.warnings.parser.FileWarningsParser;
import hudson.plugins.warnings.parser.ParserRegistry;
import hudson.plugins.warnings.parser.ParsingCanceledException;
import hudson.plugins.warnings.parser.WarningsFilter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@Deprecated
public class WarningsPublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = -5936973521277401764L;
    private static final String PLUGIN_NAME = "WARNINGS";
    private String includePattern;
    private String excludePattern;
    private String messagesPattern;
    private String categoriesPattern;
    @SuppressFBWarnings(value={"SE"})
    private List<ParserConfiguration> parserConfigurations = Lists.newArrayList();
    @SuppressFBWarnings(value={"SE"})
    private List<ConsoleParser> consoleParsers = Lists.newArrayList();
    private transient Set<String> parserNames;
    private transient boolean ignoreConsole;
    private transient String pattern;
    private transient Set<String> consoleLogParsers;

    @DataBoundConstructor
    public WarningsPublisher() {
        super(PLUGIN_NAME);
    }

    public ConsoleParser[] getConsoleParsers() {
        return ConsoleParser.filterExisting(this.consoleParsers);
    }

    @DataBoundSetter
    public void setConsoleParsers(ConsoleParser[] consoleParsers) {
        if (consoleParsers != null) {
            this.consoleParsers.addAll(Arrays.asList(consoleParsers));
        }
    }

    public ParserConfiguration[] getParserConfigurations() {
        return ParserConfiguration.filterExisting(this.parserConfigurations);
    }

    @DataBoundSetter
    public void setParserConfigurations(ParserConfiguration[] parserConfigurations) {
        if (parserConfigurations != null) {
            this.parserConfigurations.addAll(Arrays.asList(parserConfigurations));
        }
    }

    public String getIncludePattern() {
        return this.includePattern;
    }

    @DataBoundSetter
    public void setIncludePattern(String pattern) {
        this.includePattern = pattern;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    @DataBoundSetter
    public void setExcludePattern(String pattern) {
        this.excludePattern = pattern;
    }

    public String getMessagesPattern() {
        return this.messagesPattern;
    }

    public String getCategoriesPattern() {
        return this.categoriesPattern;
    }

    @DataBoundSetter
    public void setMessagesPattern(String pattern) {
        this.messagesPattern = pattern;
    }

    @DataBoundSetter
    public void setCategoriesPattern(String pattern) {
        this.categoriesPattern = pattern;
    }

    protected Object readResolve() {
        super.readResolve();
        if (this.consoleParsers == null) {
            this.consoleParsers = Lists.newArrayList();
            if (this.isOlderThanRelease318()) {
                this.upgradeFrom318();
            }
            for (String parser : this.consoleLogParsers) {
                this.consoleParsers.add(new ConsoleParser(parser));
            }
        }
        this.replaceConsoleParsersWithChangedName();
        this.replaceFileParsersWithChangedName();
        return this;
    }

    private void replaceConsoleParsersWithChangedName() {
        ArrayList<ConsoleParser> updatedConsoleParsers = new ArrayList<ConsoleParser>(this.consoleParsers);
        for (ConsoleParser parser : this.consoleParsers) {
            String group;
            String parserName = parser.getParserName();
            if (ParserRegistry.exists(parserName) && !(group = this.getGroup(parserName)).equals(parserName)) {
                updatedConsoleParsers.remove((Object)parser);
                updatedConsoleParsers.add(new ConsoleParser(group));
            }
            this.consoleParsers = updatedConsoleParsers;
        }
    }

    private void replaceFileParsersWithChangedName() {
        ArrayList<ParserConfiguration> updatedFileParsers = new ArrayList<ParserConfiguration>(this.parserConfigurations);
        for (ParserConfiguration parser : this.parserConfigurations) {
            String group;
            String parserName = parser.getParserName();
            if (ParserRegistry.exists(parserName) && !(group = this.getGroup(parserName)).equals(parserName)) {
                updatedFileParsers.remove((Object)parser);
                updatedFileParsers.add(new ParserConfiguration(parser.getPattern(), group));
            }
            this.parserConfigurations = updatedFileParsers;
        }
    }

    private String getGroup(String parserName) {
        return ParserRegistry.getParser(parserName).getGroup();
    }

    private void upgradeFrom318() {
        this.consoleLogParsers = Sets.newHashSet();
        this.parserConfigurations = Lists.newArrayList();
        if (this.parserNames != null) {
            this.convertToNewFormat();
        }
    }

    private boolean isOlderThanRelease318() {
        return this.consoleLogParsers == null || this.parserConfigurations == null;
    }

    private void convertToNewFormat() {
        if (!this.ignoreConsole) {
            this.consoleLogParsers.addAll(this.parserNames);
        }
        if (StringUtils.isNotBlank((String)this.pattern)) {
            for (String parser : this.parserNames) {
                this.parserConfigurations.add(new ParserConfiguration(this.pattern, parser));
            }
        }
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        throw new IllegalStateException("Not available since release 4.0.");
    }

    private List<String> getParsers() {
        ArrayList parsers = Lists.newArrayList();
        for (ConsoleParser consoleParser : this.getConsoleParsers()) {
            parsers.add(consoleParser.getParserName());
        }
        for (AbstractDescribableImpl abstractDescribableImpl : this.getParserConfigurations()) {
            parsers.add(abstractDescribableImpl.getParserName());
        }
        return parsers;
    }

    protected BuildResult perform(Run<?, ?> run, FilePath workspace, PluginLogger logger) throws InterruptedException, IOException {
        try {
            if (!this.hasConsoleParsers() && !this.hasFileParsers()) {
                throw new IOException("Error: No warning parsers defined in the job configuration.");
            }
            List<ParserResult> fileResults = this.parseFiles(run, workspace, logger);
            List<ParserResult> consoleResults = this.parseConsoleLog(run, workspace, logger);
            ParserResult totals = new ParserResult();
            this.add(totals, consoleResults);
            this.add(totals, fileResults);
            BuildHistory history = new BuildHistory(run, AggregatedWarningsResultAction.class, this.usePreviousBuildAsReference(), this.useOnlyStableBuildsAsReference());
            AggregatedWarningsResult result = new AggregatedWarningsResult(run, history, totals, this.getDefaultEncoding());
            run.addAction((Action)new AggregatedWarningsResultAction(run, result));
            return result;
        }
        catch (ParsingCanceledException exception) {
            return this.emptyBuildResult(run, logger, exception);
        }
        catch (InterruptedException exception) {
            return this.emptyBuildResult(run, logger, exception);
        }
    }

    private BuildResult emptyBuildResult(Run<?, ?> run, PluginLogger logger, Exception exception) {
        logger.log(exception.getMessage());
        return new AggregatedWarningsResult(run, (BuildHistory)new NullBuildHistory(), new ParserResult(), this.getDefaultEncoding());
    }

    private boolean hasFileParsers() {
        return this.getParserConfigurations().length > 0;
    }

    private boolean hasConsoleParsers() {
        return this.getConsoleParsers().length > 0;
    }

    private void add(ParserResult totals, List<ParserResult> results) {
        for (ParserResult result : results) {
            totals.addProject(result);
        }
    }

    private InterruptedException createInterruptedException() {
        return new InterruptedException("Canceling parsing since build has been aborted.");
    }

    private void returnIfCanceled() throws InterruptedException {
        if (Thread.interrupted()) {
            throw this.createInterruptedException();
        }
    }

    private List<ParserResult> parseConsoleLog(Run<?, ?> run, FilePath workspace, PluginLogger logger) throws IOException, InterruptedException {
        ArrayList results = Lists.newArrayList();
        for (ConsoleParser parser : this.getConsoleParsers()) {
            String parserName = parser.getParserName();
            logger.log("Parsing warnings in console log with parser " + parserName);
            Collection<FileAnnotation> warnings = new ParserRegistry(ParserRegistry.getParsers(parserName), this.getDefaultEncoding()).parse(run.getLogFile());
            if (!workspace.isRemote()) {
                this.guessModuleNames(workspace, warnings);
            }
            ParserResult project = new ParserResult(workspace, this.canResolveRelativePaths());
            project.addAnnotations(warnings);
            results.add(this.annotate(run, workspace, this.filterWarnings(project, logger), parserName));
        }
        return results;
    }

    private ParserResult filterWarnings(ParserResult project, PluginLogger logger) {
        WarningsFilter filter = new WarningsFilter();
        if (filter.isActive(this.getIncludePattern(), this.getExcludePattern(), this.getMessagesPattern(), this.getCategoriesPattern())) {
            Collection<FileAnnotation> filtered = filter.apply(project.getAnnotations(), this.getIncludePattern(), this.getExcludePattern(), this.getMessagesPattern(), this.getCategoriesPattern(), logger);
            return new ParserResult(filtered);
        }
        return project;
    }

    private void guessModuleNames(FilePath workspace, Collection<FileAnnotation> warnings) {
        ModuleDetector detector = this.createModuleDetector(workspace.getRemote());
        for (FileAnnotation annotation : warnings) {
            String module = detector.guessModuleName(annotation.getFileName());
            annotation.setModuleName(module);
        }
    }

    private List<ParserResult> parseFiles(Run<?, ?> run, FilePath workspace, PluginLogger logger) throws IOException, InterruptedException {
        ArrayList results = Lists.newArrayList();
        for (ParserConfiguration configuration : this.getParserConfigurations()) {
            String filePattern = this.expandFilePattern(configuration.getPattern(), run.getEnvironment(TaskListener.NULL));
            String parserName = configuration.getParserName();
            logger.log("Parsing warnings in files '" + filePattern + "' with parser " + parserName);
            FilesParser parser = new FilesParser(PLUGIN_NAME, filePattern, (AnnotationParser)new FileWarningsParser(ParserRegistry.getParsers(parserName), this.getDefaultEncoding()), this.shouldDetectModules(), this.isMavenBuild(run), this.canResolveRelativePaths());
            ParserResult project = (ParserResult)workspace.act((FilePath.FileCallable)parser);
            logger.logLines(project.getLogMessages());
            this.returnIfCanceled();
            results.add(this.annotate(run, workspace, this.filterWarnings(project, logger), configuration.getParserName()));
        }
        return results;
    }

    private ParserResult annotate(Run<?, ?> run, FilePath workspace, ParserResult input, String parserName) throws IOException, InterruptedException {
        ParserResult output = (ParserResult)workspace.act((FilePath.FileCallable)new AnnotationsClassifier(input, this.getDefaultEncoding()));
        for (FileAnnotation annotation : output.getAnnotations()) {
            annotation.setPathName(workspace.getRemote());
        }
        WarningsBuildHistory history = new WarningsBuildHistory(run, parserName, this.usePreviousBuildAsReference(), this.useOnlyStableBuildsAsReference());
        this.blame(output.getAnnotations(), run, workspace);
        WarningsResult result = new WarningsResult(run, history, output, this.getDefaultEncoding(), parserName);
        run.addAction((Action)new WarningsResultAction(run, (HealthDescriptor)this, result, parserName));
        return output;
    }

    private ModuleDetector createModuleDetector(String workspace) {
        if (this.shouldDetectModules()) {
            return new ModuleDetector(new File(workspace));
        }
        return new NullModuleDetector();
    }

    public WarningsDescriptor getDescriptor() {
        return (WarningsDescriptor)super.getDescriptor();
    }

    public MatrixAggregator createAggregator(MatrixBuild run, Launcher launcher, BuildListener listener) {
        return new WarningsAnnotationsAggregator(run, launcher, listener, (HealthDescriptor)this, this.getDefaultEncoding(), this.usePreviousBuildAsReference(), this.useOnlyStableBuildsAsReference());
    }
}

