/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.AbstractWarningsParser;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.ParsingCanceledException;
import hudson.plugins.warnings.parser.Warning;
import hudson.plugins.warnings.util.XmlElementUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Deprecated
@Extension
public class StyleCopParser
extends AbstractWarningsParser {
    private static final long serialVersionUID = 1L;

    public StyleCopParser() {
        super(Messages._Warnings_StyleCop_ParserName(), Messages._Warnings_StyleCop_LinkName(), Messages._Warnings_StyleCop_TrendName());
    }

    @Override
    public Collection<FileAnnotation> parse(Reader reader) throws IOException, ParsingCanceledException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new InputSource(reader));
            NodeList mainNode = doc.getElementsByTagName("SourceAnalysisViolations");
            if (mainNode.getLength() == 0) {
                mainNode = doc.getElementsByTagName("StyleCopViolations");
            }
            Element rootElement = (Element)mainNode.item(0);
            return this.parseViolations(XmlElementUtil.getNamedChildElements(rootElement, "Violation"));
        }
        catch (ParserConfigurationException exception) {
            throw new IOException(exception);
        }
        catch (SAXException exception) {
            throw new IOException(exception);
        }
    }

    private Collection<FileAnnotation> parseViolations(List<Element> elements) {
        ArrayList warnings = Lists.newArrayList();
        for (Element element : elements) {
            Warning warning = this.createWarning(this.getString(element, "Source"), this.getLineNumber(element), this.getString(element, "Rule"), this.getCategory(element), element.getTextContent(), Priority.NORMAL);
            warnings.add(warning);
        }
        return warnings;
    }

    private String getCategory(Element element) {
        String ruleNameSpace = this.getString(element, "RuleNamespace");
        int i = ruleNameSpace.lastIndexOf(46);
        if (i == -1) {
            return this.getString(element, "RuleId");
        }
        return ruleNameSpace.substring(i + 1);
    }

    private String getString(Element element, String name) {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        return "";
    }

    private int getLineNumber(Element violation) {
        if (violation.hasAttribute("LineNumber")) {
            return this.getLineNumber(violation.getAttribute("LineNumber"));
        }
        return 0;
    }
}

