/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.ArrayList;
import java.util.regex.Matcher;

@Deprecated
@Extension
public class CadenceIncisiveParser
extends RegexpLineParser {
    private static final String SLASH = "/";
    private static final String CADENCE_MESSAGE_PATTERN = "((^[a-zA-Z]+): \\*([a-zA-Z]),([a-zA-Z]+): (.*) \\[File:(.*), Line:(.*)\\].)|((^[a-zA-Z]+): \\*([a-zA-Z]),([a-zA-Z]+) \\((.*),([0-9]+)\\|([0-9]+)\\): (.*)$)|((^g?make\\[.*\\]: Entering directory)\\s*(['`]((.*))\\'))|((^[a-zA-Z]+): \\*([a-zA-Z]),([a-zA-Z]+): (.*)$)";
    private String directory = "";

    public CadenceIncisiveParser() {
        super(Messages._Warnings_CadenceIncisive_ParserName(), Messages._Warnings_CadenceIncisive_LinkName(), Messages._Warnings_CadenceIncisive_TrendName(), CADENCE_MESSAGE_PATTERN);
    }

    private Warning handleDirectory(Matcher matcher, int offset) {
        this.directory = matcher.group(offset) + SLASH;
        return FALSE_POSITIVE;
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String message;
        String fileName;
        String category;
        String tool;
        int lineNumber = 0;
        boolean column = false;
        ArrayList<String> arr = new ArrayList<String>();
        int n = matcher.groupCount();
        for (int i = 0; i <= n; ++i) {
            arr.add(i, matcher.group(i));
        }
        Priority priority = Priority.LOW;
        if (matcher.group(1) != null) {
            tool = matcher.group(2);
            String type = matcher.group(3);
            category = matcher.group(4);
            fileName = matcher.group(6);
            lineNumber = this.getLineNumber(matcher.group(7));
            message = matcher.group(5);
            priority = Priority.NORMAL;
        } else {
            if (matcher.group(16) != null) {
                return this.handleDirectory(matcher, 20);
            }
            if (matcher.group(8) != null) {
                tool = matcher.group(9);
                String type = matcher.group(10);
                category = matcher.group(11);
                fileName = matcher.group(12);
                lineNumber = this.getLineNumber(matcher.group(13));
                priority = Priority.NORMAL;
                message = matcher.group(15);
            } else if (matcher.group(21) != null) {
                tool = matcher.group(22);
                String type = matcher.group(23);
                category = matcher.group(24);
                message = matcher.group(25);
                fileName = "/NotFileRelated";
            } else {
                return FALSE_POSITIVE;
            }
        }
        if (category.equalsIgnoreCase("E")) {
            priority = Priority.HIGH;
            category = "Error (" + tool + "): " + category;
        } else {
            category = "Warning (" + tool + "): " + category;
        }
        if (fileName == null) {
            return FALSE_POSITIVE;
        }
        if (fileName.startsWith(SLASH)) {
            return this.createWarning(fileName, lineNumber, category, message, priority);
        }
        return this.createWarning(this.directory + fileName, lineNumber, category, message, priority);
    }
}

