/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.plugins.warnings.Messages;
import hudson.plugins.warnings.parser.AbstractWarningsParser;
import hudson.plugins.warnings.parser.DynamicDocumentParser;
import hudson.plugins.warnings.parser.DynamicParser;
import hudson.plugins.warnings.parser.GroovyExpressionMatcher;
import hudson.plugins.warnings.parser.Warning;
import hudson.util.FormValidation;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilationFailedException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

@Deprecated
public class GroovyParser
extends AbstractDescribableImpl<GroovyParser> {
    private static final int MAX_EXAMPLE_SIZE = 4096;
    private final String name;
    private final String regexp;
    private final String script;
    private final String example;
    private String linkName;
    private String trendName;
    @CheckForNull
    private transient AbstractWarningsParser parser;

    @DataBoundConstructor
    public GroovyParser(String name, String regexp, String script, String example, String linkName, String trendName) {
        this.name = name;
        this.regexp = regexp;
        this.script = script;
        this.example = example.length() > 4096 ? example.substring(0, 4096) : example;
        this.linkName = linkName;
        this.trendName = trendName;
        this.parser = this.createParser();
    }

    public GroovyParser(String name, String regexp, String script) {
        this(name, regexp, script, "", name, name);
    }

    private Object readResolve() {
        if (this.linkName == null) {
            this.linkName = Messages._Warnings_ProjectAction_Name().toString(Locale.ENGLISH);
        }
        if (this.trendName == null) {
            this.trendName = Messages._Warnings_Trend_Name().toString(Locale.ENGLISH);
        }
        this.parser = this.createParser();
        return this;
    }

    public boolean isValid() {
        return this.parser != null;
    }

    private boolean canCreateParser() {
        DescriptorImpl d = new DescriptorImpl();
        return d.doCheckScript((String)this.script).kind == FormValidation.Kind.OK && d.doCheckRegexp((String)this.regexp).kind == FormValidation.Kind.OK && ((DescriptorImpl)d).validate((String)this.name, (String)Messages.Warnings_GroovyParser_Error_Name_isEmpty()).kind == FormValidation.Kind.OK;
    }

    public String getName() {
        return this.name;
    }

    public String getTrendName() {
        return this.trendName;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public String getScript() {
        return this.script;
    }

    public String getExample() {
        return StringUtils.defaultString((String)this.example);
    }

    public final boolean hasMultiLineSupport() {
        return GroovyParser.containsNewline(this.regexp);
    }

    private static boolean containsNewline(String expression) {
        return StringUtils.contains((String)expression, (String)"\\n");
    }

    @CheckForNull
    private AbstractWarningsParser createParser() {
        if (this.canCreateParser()) {
            if (this.hasMultiLineSupport()) {
                return new DynamicDocumentParser(this.name, this.regexp, this.script, this.linkName, this.trendName);
            }
            return new DynamicParser(this.name, this.regexp, this.script, this.linkName, this.trendName);
        }
        return null;
    }

    @CheckForNull
    public AbstractWarningsParser getParser() {
        return this.parser;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<GroovyParser> {
        private static final String NEWLINE = "\n";
        private static final int MAX_MESSAGE_LENGTH = 60;
        private static final FormValidation NO_RUN_SCRIPT_PERMISSION_WARNING = FormValidation.warning((String)Messages.Warnings_GroovyParser_Warning_NoRunScriptPermission());

        private FormValidation validate(String name, String message) {
            if (StringUtils.isBlank((String)name)) {
                return FormValidation.error((String)message);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckName(@QueryParameter(required=true) String name) {
            return this.validate(name, Messages.Warnings_GroovyParser_Error_Name_isEmpty());
        }

        public FormValidation doCheckLinkName(@QueryParameter(required=true) String linkName) {
            return this.validate(linkName, Messages.Warnings_GroovyParser_Error_LinkName_isEmpty());
        }

        public FormValidation doCheckTrendName(@QueryParameter(required=true) String trendName) {
            return this.validate(trendName, Messages.Warnings_GroovyParser_Error_TrendName_isEmpty());
        }

        public FormValidation doCheckRegexp(@QueryParameter(required=true) String regexp) {
            try {
                if (StringUtils.isBlank((String)regexp)) {
                    return FormValidation.error((String)Messages.Warnings_GroovyParser_Error_Regexp_isEmpty());
                }
                Pattern.compile(regexp);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException exception) {
                return FormValidation.error((String)Messages.Warnings_GroovyParser_Error_Regexp_invalid(exception.getLocalizedMessage()));
            }
        }

        public FormValidation doCheckScript(@QueryParameter(required=true) String script) {
            if (!this.canRunScripts()) {
                return NO_RUN_SCRIPT_PERMISSION_WARNING;
            }
            try {
                if (StringUtils.isBlank((String)script)) {
                    return FormValidation.error((String)Messages.Warnings_GroovyParser_Error_Script_isEmpty());
                }
                GroovyExpressionMatcher matcher = new GroovyExpressionMatcher(script, null);
                matcher.compile();
                return FormValidation.ok();
            }
            catch (CompilationFailedException exception) {
                return FormValidation.error((String)Messages.Warnings_GroovyParser_Error_Script_invalid(exception.getLocalizedMessage()));
            }
        }

        private boolean canRunScripts() {
            return Jenkins.getInstance().getACL().hasPermission(Jenkins.RUN_SCRIPTS);
        }

        public FormValidation doCheckExample(@QueryParameter String example, @QueryParameter String regexp, @QueryParameter String script) {
            if (!this.canRunScripts()) {
                return NO_RUN_SCRIPT_PERMISSION_WARNING;
            }
            if (StringUtils.isNotBlank((String)example) && StringUtils.isNotBlank((String)regexp) && StringUtils.isNotBlank((String)script)) {
                FormValidation response = this.parseExample(script, example, regexp, GroovyParser.containsNewline(regexp));
                if (example.length() <= 4096) {
                    return response;
                }
                return FormValidation.aggregate(Arrays.asList(FormValidation.warning((String)Messages.GroovyParser_long_examples_will_be_truncated()), response));
            }
            return FormValidation.ok();
        }

        private FormValidation parseExample(String script, String example, String regexp, boolean hasMultiLineSupport) {
            Pattern pattern = hasMultiLineSupport ? Pattern.compile(regexp, 8) : Pattern.compile(regexp);
            Matcher matcher = pattern.matcher(example);
            if (matcher.find()) {
                GroovyExpressionMatcher checker = new GroovyExpressionMatcher(script, null);
                Object result = null;
                try {
                    result = checker.run(matcher, 0);
                }
                catch (Exception exception) {
                    return FormValidation.error((String)Messages.Warnings_GroovyParser_Error_Example_exception(exception.getMessage()));
                }
                if (result instanceof Warning) {
                    StringBuilder okMessage = new StringBuilder(Messages.Warnings_GroovyParser_Error_Example_ok_title());
                    Warning warning = (Warning)((Object)result);
                    this.message(okMessage, Messages.Warnings_GroovyParser_Error_Example_ok_file(warning.getFileName()));
                    this.message(okMessage, Messages.Warnings_GroovyParser_Error_Example_ok_line(warning.getPrimaryLineNumber()));
                    this.message(okMessage, Messages.Warnings_GroovyParser_Error_Example_ok_priority(warning.getPriority().getLongLocalizedString()));
                    this.message(okMessage, Messages.Warnings_GroovyParser_Error_Example_ok_category(warning.getCategory()));
                    this.message(okMessage, Messages.Warnings_GroovyParser_Error_Example_ok_type(warning.getType()));
                    this.message(okMessage, Messages.Warnings_GroovyParser_Error_Example_ok_message(warning.getMessage()));
                    return FormValidation.ok((String)okMessage.toString());
                }
                return FormValidation.error((String)Messages.Warnings_GroovyParser_Error_Example_wrongReturnType(result));
            }
            return FormValidation.error((String)Messages.Warnings_GroovyParser_Error_Example_regexpDoesNotMatch());
        }

        private void message(StringBuilder okMessage, String message) {
            okMessage.append(NEWLINE);
            int max = 60;
            if (message.length() > max) {
                int size = max / 2 - 1;
                okMessage.append(message.substring(0, size));
                okMessage.append("[...]");
                okMessage.append(message.substring(message.length() - size, message.length()));
            } else {
                okMessage.append(message);
            }
        }

        public String getDisplayName() {
            return "";
        }
    }
}

