/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

public class Gcc4CompilerParser
extends RegexpLineParser {
    static final String WARNING_CATEGORY = "GCC4 Error";
    static final String WARNING_TYPE = "gcc4";
    private static final String GCC_WARNING_PATTERN = "^(.+?):(\\d+):(?:\\d+:)? (warning|error): (.*)$";

    public Gcc4CompilerParser() {
        super(GCC_WARNING_PATTERN, "GNU compiler 4 (gcc)");
    }

    protected Warning createWarning(Matcher matcher) {
        String fileName = matcher.group(1);
        int lineNumber = this.getLineNumber(matcher.group(2));
        String message = matcher.group(4);
        Priority priority = matcher.group(3).equalsIgnoreCase("error") ? Priority.HIGH : Priority.NORMAL;
        return new Warning(fileName, lineNumber, WARNING_TYPE, WARNING_CATEGORY, message, priority);
    }
}

