/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.testlink.TestLinkBuildAction;
import hudson.plugins.testlink.TestLinkProjectAction;
import hudson.plugins.testlink.TestLinkPublisherDescriptor;
import hudson.plugins.testlink.TestLinkReport;
import hudson.plugins.testlink.TestLinkResult;
import hudson.plugins.testlink.model.TestLinkParser;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLinkPublisher
extends Recorder
implements Serializable {
    @Extension
    public static final TestLinkPublisherDescriptor DESCRIPTOR = new TestLinkPublisherDescriptor();

    @DataBoundConstructor
    public TestLinkPublisher() {
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new TestLinkProjectAction(project);
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("Performing TestLink publisher...");
        if (this.canContinue(build.getResult())) {
            TestLinkReport report;
            FilePath workspace = build.getWorkspace();
            PrintStream logger = listener.getLogger();
            TestLinkParser parser = new TestLinkParser(logger);
            listener.getLogger().println("Generating report...");
            try {
                report = (TestLinkReport)workspace.act((FilePath.FileCallable)parser);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(logger);
                return false;
            }
            catch (InterruptedException ie) {
                ie.printStackTrace(logger);
                return false;
            }
            TestLinkResult result = new TestLinkResult(report, build);
            TestLinkBuildAction buildAction = new TestLinkBuildAction(build, result);
            build.addAction((Action)buildAction);
        } else {
            listener.getLogger().println("Canceling TestLink publisher. Wrong project status.");
        }
        return true;
    }
}

