/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink;

import hudson.plugins.testlink.TestLinkReport;
import hudson.plugins.testlink.model.TestLinkTestCase;

public class ReportSummary {
    public static String createReportSummary(TestLinkReport report, TestLinkReport previous) {
        StringBuilder builder = new StringBuilder();
        builder.append("<p><b>Build ID " + report.getBuildId() + "</b> - <b>Build Name [" + report.getBuildName() + "]</b></p>");
        builder.append("<p><a href=\"testLinkResult\">Total of ");
        builder.append(report.getTestsTotal());
        if (previous != null) {
            ReportSummary.printDifference(report.getTestsTotal(), previous.getTestsTotal(), builder);
        }
        builder.append(" tests.</a> where ");
        builder.append(report.getTestsPassed());
        if (previous != null) {
            ReportSummary.printDifference(report.getTestsPassed(), previous.getTestsPassed(), builder);
        }
        builder.append(" tests passed, ");
        builder.append(report.getTestsFailed());
        if (previous != null) {
            ReportSummary.printDifference(report.getTestsFailed(), previous.getTestsFailed(), builder);
        }
        builder.append(" tests failed and ");
        builder.append(report.getTestsBlocked());
        if (previous != null) {
            ReportSummary.printDifference(report.getTestsBlocked(), previous.getTestsBlocked(), builder);
        }
        builder.append(" tests were blocked.</p>");
        return builder.toString();
    }

    public static String createReportSummaryDetails(TestLinkReport report, TestLinkReport previous) {
        StringBuilder builder = new StringBuilder();
        builder.append("<p>List of test cases and execution result status.</p>");
        builder.append("<table border=\"1\">\n");
        builder.append("<tr><th>Id</th><th>Plan Id</th><th>Build Id</th><th>Category</th><th>File</th><th>Result Status</th></tr>\n");
        for (TestLinkTestCase tc : report.getListOfTestCases()) {
            builder.append("<tr>\n");
            builder.append("<td>" + tc.getId() + "</td>");
            builder.append("<td>" + tc.getPlanId() + "</td>");
            builder.append("<td>" + tc.getBuildId() + "</td>");
            builder.append("<td>" + tc.getCategory() + "</td>\n");
            builder.append("<td>" + tc.getFile() + "</td>\n");
            builder.append("<td>" + tc.getResultStatus() + "</td>\n");
            builder.append("</tr>\n");
        }
        builder.append("</table>");
        return builder.toString();
    }

    private static void printDifference(int current, int previous, StringBuilder builder) {
        int difference = current - previous;
        builder.append(" (");
        if (difference >= 0) {
            builder.append('+');
        }
        builder.append(difference);
        builder.append(")");
    }
}

