/*
 * Decompiled with CFR 0.152.
 */
package hpi;

import hpi.ScriptSelectionTaskDefinition;
import hudson.model.BooleanParameterDefinition;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.FileParameterDefinition;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.PasswordParameterDefinition;
import hudson.model.RunParameterDefinition;
import hudson.model.StringParameterDefinition;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaxParser
extends DefaultHandler {
    private File configFile;
    List<ParameterDefinition> params;
    private String tempVal;
    private ParameterDefinition tempParam;
    private String name;
    private String description;
    private String type;
    private String value;
    private List<String> choices;
    private String path;
    private String testDelimSymbol;
    private String nodeDelimSymbol;
    private String countDelimiterSymbol;
    private String delimiter;

    public SaxParser(File configFile) {
        this.configFile = configFile;
        this.params = new LinkedList<ParameterDefinition>();
        this.choices = new LinkedList<String>();
    }

    public List<ParameterDefinition> load() throws ParserConfigurationException, SAXException, IOException {
        this.parseDocument();
        return this.params;
    }

    private void parseDocument() throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser sp = spf.newSAXParser();
        sp.parse(this.configFile, (DefaultHandler)this);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tempVal = "";
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.tempVal = new String(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Name")) {
            this.name = this.tempVal;
            return;
        }
        if (qName.equalsIgnoreCase("Description")) {
            this.description = this.tempVal;
            return;
        }
        if (qName.equalsIgnoreCase("Type")) {
            this.type = this.tempVal;
            return;
        }
        if (qName.equalsIgnoreCase("Value")) {
            this.value = this.tempVal;
            return;
        }
        if (qName.equalsIgnoreCase("Choice")) {
            this.choices.add(this.tempVal);
            return;
        }
        if (qName.equalsIgnoreCase("Path")) {
            this.path = this.tempVal;
            return;
        }
        if (qName.equalsIgnoreCase("TestDelimSymbol")) {
            this.testDelimSymbol = this.tempVal;
            return;
        }
        if (qName.equalsIgnoreCase("NodeDelimSymbol")) {
            this.nodeDelimSymbol = this.tempVal;
            return;
        }
        if (qName.equalsIgnoreCase("CountDelimiterSymbol")) {
            this.countDelimiterSymbol = this.tempVal;
        }
        if (qName.equalsIgnoreCase("Delimiter")) {
            this.delimiter = this.tempVal;
            return;
        }
        if (qName.equalsIgnoreCase("Parameter")) {
            if (this.type.equalsIgnoreCase("Boolean")) {
                this.tempParam = new BooleanParameterDefinition(this.name, new Boolean(this.value).booleanValue(), this.description);
                this.params.add(this.tempParam);
                return;
            }
            if (this.type.equalsIgnoreCase("Choice")) {
                this.tempParam = new ChoiceParameterDefinition(this.name, this.choices.toArray(new String[0]), this.description);
                this.params.add(this.tempParam);
                this.choices.clear();
                return;
            }
            if (this.type.equalsIgnoreCase("String")) {
                this.tempParam = new StringParameterDefinition(this.name, this.value, this.description);
                this.params.add(this.tempParam);
                return;
            }
            if (this.type.equalsIgnoreCase("Password")) {
                this.tempParam = new PasswordParameterDefinition(this.name, this.value, this.description);
                this.params.add(this.tempParam);
                return;
            }
            if (this.type.equalsIgnoreCase("Run")) {
                this.tempParam = new RunParameterDefinition(this.name, this.value, this.description);
                this.params.add(this.tempParam);
                return;
            }
            if (this.type.equalsIgnoreCase("File")) {
                this.tempParam = new FileParameterDefinition(this.name, this.description);
                this.params.add(this.tempParam);
                return;
            }
            if (this.type.equalsIgnoreCase("hpi.ScriptSelectionTaskDefinition") && Hudson.getInstance().getPlugin("selection-tasks-plugin") != null) {
                this.tempParam = new ScriptSelectionTaskDefinition(this.name, this.path, null, this.testDelimSymbol, this.nodeDelimSymbol, this.description, Integer.parseInt(this.countDelimiterSymbol), this.delimiter, this.value);
                this.params.add(this.tempParam);
                return;
            }
        }
    }
}

