/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sitemonitor;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.sitemonitor.Messages;
import hudson.plugins.sitemonitor.SiteMonitorDescriptor;
import hudson.plugins.sitemonitor.SiteMonitorRootAction;
import hudson.plugins.sitemonitor.model.Result;
import hudson.plugins.sitemonitor.model.Site;
import hudson.plugins.sitemonitor.model.Status;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SiteMonitorRecorder
extends Recorder {
    private static final int MILLISECS_IN_SECS = 1000;
    private List<Site> mSites;

    public SiteMonitorRecorder(List<Site> sites) {
        this.mSites = sites;
    }

    public final List<Site> getSites() {
        return this.mSites;
    }

    private HttpURLConnection getConnection(String urlString, boolean admitInsecureSslCerts) throws MalformedURLException, IOException, NoSuchAlgorithmException, KeyManagementException {
        if (urlString.startsWith("https://")) {
            HttpsURLConnection connection = (HttpsURLConnection)ProxyConfiguration.open((URL)new URL(urlString));
            if (admitInsecureSslCerts) {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
                connection.setSSLSocketFactory(ctx.getSocketFactory());
                connection.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String arg0, SSLSession arg1) {
                        return true;
                    }
                });
            }
            return connection;
        }
        if (urlString.contains("@")) {
            URL passedURL = new URL(urlString);
            String creds = urlString.substring(urlString.indexOf("//") + 2, urlString.indexOf("@"));
            String userName = creds.substring(0, creds.indexOf(":"));
            String passWord = creds.substring(creds.indexOf(":") + 1, creds.length());
            String userPassword = userName + ":" + passWord;
            String encoding = Base64.getEncoder().encodeToString(userPassword.getBytes("utf-8"));
            HttpURLConnection connection = (HttpURLConnection)ProxyConfiguration.open((URL)passedURL);
            connection.setRequestProperty("Authorization", "Basic " + encoding);
            return connection;
        }
        return (HttpURLConnection)ProxyConfiguration.open((URL)new URL(urlString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArrayList<Result> results = new ArrayList<Result>();
        SiteMonitorDescriptor descriptor = (SiteMonitorDescriptor)this.getDescriptor();
        if (CookieHandler.getDefault() == null) {
            CookieHandler.setDefault(new CookieManager());
        }
        boolean hasFailure = false;
        for (Site site : this.mSites) {
            Status status;
            Integer responseCode = null;
            String note = "";
            HttpURLConnection connection = null;
            String url = site.getUrl();
            EnvVars env = build.getEnvironment((TaskListener)listener);
            url = env.expand(url);
            try {
                connection = this.getConnection(url, site.getAdmitInsecureSslCerts());
                if (site.getTimeout() != null) {
                    connection.setConnectTimeout(site.getTimeout() * 1000);
                } else {
                    connection.setConnectTimeout(descriptor.getTimeout() * 1000);
                }
                responseCode = connection.getResponseCode();
                List<Integer> successResponseCodes = descriptor.getSuccessResponseCodes();
                if (site.getSuccessResponseCodes() != null && site.getSuccessResponseCodes().size() > 0) {
                    successResponseCodes = site.getSuccessResponseCodes();
                }
                status = successResponseCodes.contains(responseCode) ? Status.UP : Status.ERROR;
            }
            catch (SocketTimeoutException ste) {
                listener.getLogger().println(ste + " - " + ste.getMessage());
                status = Status.DOWN;
            }
            catch (Exception e) {
                note = e + " - " + e.getMessage();
                listener.getLogger().println(note);
                status = Status.EXCEPTION;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            note = "[" + (Object)((Object)status) + "] " + note;
            listener.getLogger().println(Messages.SiteMonitor_Console_URL() + url + ", " + Messages.SiteMonitor_Console_ResponseCode() + responseCode + ", " + Messages.SiteMonitor_Console_Status() + (Object)((Object)status));
            if (!hasFailure && status != Status.UP) {
                hasFailure = true;
            }
            Result result = new Result(site, responseCode, status, note);
            results.add(result);
        }
        build.addAction((Action)new SiteMonitorRootAction(results));
        hudson.model.Result result = hasFailure ? hudson.model.Result.FAILURE : hudson.model.Result.SUCCESS;
        build.setResult(result);
        return !hasFailure;
    }

    public final BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

