/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sitemonitor;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.plugins.sitemonitor.Messages;
import hudson.plugins.sitemonitor.SiteMonitorRecorder;
import hudson.plugins.sitemonitor.SiteMonitorValidator;
import hudson.plugins.sitemonitor.mapper.JsonToSiteMapper;
import hudson.plugins.sitemonitor.mapper.JsonToSuccessResponseList;
import hudson.plugins.sitemonitor.mapper.SuccessCodeListToCvString;
import hudson.plugins.sitemonitor.model.Site;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class SiteMonitorDescriptor
extends BuildStepDescriptor<Publisher> {
    private static final Logger LOGGER = Logger.getLogger(SiteMonitorDescriptor.class.getName());
    private static final Integer DEFAULT_TIMEOUT_IN_SECS = 30;
    private SiteMonitorValidator mValidator;
    private List<Integer> mSuccessResponseCodes;
    private Integer mTimeout;

    public SiteMonitorDescriptor() {
        super(SiteMonitorRecorder.class);
        this.load();
        this.mValidator = new SiteMonitorValidator();
    }

    public final String getDisplayName() {
        return Messages.SiteMonitor_DescriptorName();
    }

    public final boolean isApplicable(Class<? extends AbstractProject> clazz) {
        return true;
    }

    public final List<Integer> getSuccessResponseCodes() {
        if (this.mSuccessResponseCodes == null) {
            this.mSuccessResponseCodes = new ArrayList<Integer>();
            this.mSuccessResponseCodes.add(200);
        }
        return this.mSuccessResponseCodes;
    }

    public final String getSuccessResponseCodesCsv() {
        return SuccessCodeListToCvString.INSTANCE.apply(this.mSuccessResponseCodes);
    }

    public final Integer getTimeout() {
        if (this.mTimeout == null) {
            this.mTimeout = DEFAULT_TIMEOUT_IN_SECS;
        }
        return this.mTimeout;
    }

    public final Publisher newInstance(StaplerRequest request, JSONObject json) {
        LOGGER.fine("json: " + json);
        ArrayList<Site> sites = new ArrayList<Site>();
        Object sitesObject = json.get("sites");
        if (sitesObject instanceof JSONObject) {
            this.addSite(sites, json.getJSONObject("sites"));
        } else if (sitesObject instanceof JSONArray) {
            for (Object siteObject : (JSONArray)sitesObject) {
                if (!(siteObject instanceof JSONObject)) continue;
                this.addSite(sites, (JSONObject)siteObject);
            }
        } else {
            LOGGER.warning("Unable to parse 'sites' object in JSON data. It's neither JSONObject nor JSONArray");
        }
        return new SiteMonitorRecorder(sites);
    }

    private void addSite(List<Site> sites, JSONObject siteObject) {
        if (!StringUtils.isBlank((String)siteObject.getString("url"))) {
            sites.add(JsonToSiteMapper.INSTANCE.apply(siteObject));
        }
    }

    public final boolean configure(StaplerRequest request, JSONObject json) {
        LOGGER.fine("json: " + json);
        if (!StringUtils.isBlank((String)json.getString("successResponseCodes"))) {
            this.mSuccessResponseCodes = JsonToSuccessResponseList.INSTANCE.apply(json);
        }
        this.mTimeout = json.getInt("timeout");
        this.save();
        return true;
    }

    public final FormValidation doCheckUrl(@QueryParameter String value) {
        return this.mValidator.validateUrl(value);
    }

    public final FormValidation doCheckGlobalResponseCodes(@QueryParameter String value) {
        return this.mValidator.validateResponseCodes(value);
    }

    public final FormValidation doCheckGlobalTimeout(@QueryParameter String value) {
        return this.mValidator.validateTimeout(value);
    }

    public final FormValidation doCheckResponseCodes(@QueryParameter String value) {
        if (StringUtils.isNotBlank((String)value)) {
            return this.mValidator.validateResponseCodes(value);
        }
        return FormValidation.ok();
    }

    public final FormValidation doCheckTimeout(@QueryParameter String value) {
        if (StringUtils.isNotBlank((String)value)) {
            return this.mValidator.validateTimeout(value);
        }
        return FormValidation.ok();
    }
}

