/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pwauth;

import hudson.model.Hudson;
import hudson.plugins.pwauth.PWauthSecurityRealm;
import hudson.plugins.pwauth.PWauthValidation;
import hudson.security.AuthorizationStrategy;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PWauthFilter
implements Filter {
    private static final String[] usernameParams = new String[]{"user", "username", "login"};
    private static final String[] passwordParams = new String[]{"pass", "password", "passwd", "key"};
    private final Filter superFilter;
    private final PWauthSecurityRealm pwauth;

    public PWauthFilter(Filter superFilter, PWauthSecurityRealm pwauth) {
        this.superFilter = superFilter;
        this.pwauth = pwauth;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (ServletResponse)((HttpServletResponse)response), chain);
    }

    public void doFilter(HttpServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.pwauth.enableParamAuth && this.validateParams(request)) {
            this.grantAccess(request, response, chain);
            return;
        }
        for (String whitelistedId : this.getWhitelist()) {
            if (!whitelistedId.equals(request.getRemoteAddr())) continue;
            this.grantAccess(request, response, chain);
            return;
        }
        this.superFilter.doFilter((ServletRequest)request, response, chain);
    }

    private boolean validateParams(HttpServletRequest request) {
        try {
            String username = this.getParameter(usernameParams, request);
            String password = this.getParameter(passwordParams, request);
            if (Hudson.getInstance().getSecurityRealm() instanceof PWauthSecurityRealm) {
                return ((PWauthSecurityRealm)Hudson.getInstance().getSecurityRealm()).authenticate(username, password) != null;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private String getParameter(String[] keyCandidates, HttpServletRequest request) {
        for (String key : keyCandidates) {
            if (request.getParameter(key) == null) continue;
            return request.getParameter(key);
        }
        return null;
    }

    private void grantAccess(HttpServletRequest request, ServletResponse response, FilterChain chain) throws ServletException {
        AuthorizationStrategy strategy = Hudson.getInstance().getAuthorizationStrategy();
        Hudson.getInstance().setAuthorizationStrategy(AuthorizationStrategy.UNSECURED);
        try {
            this.superFilter.doFilter((ServletRequest)request, response, chain);
        }
        catch (Exception e) {
            Hudson.getInstance().setAuthorizationStrategy(strategy);
            throw new ServletException((Throwable)e);
        }
        Hudson.getInstance().setAuthorizationStrategy(strategy);
    }

    private List<String> getWhitelist() {
        Vector<String> whitelist = new Vector<String>();
        if (this.pwauth.whitelist != null) {
            for (String ip : this.pwauth.whitelist.split("(\\s)*[,|;|\\s](\\s)*")) {
                if (!PWauthValidation.validateIP(ip)) continue;
                whitelist.add(ip.trim());
            }
        }
        return whitelist;
    }

    public void destroy() {
    }
}

