/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd;

import com.thoughtworks.xstream.XStream;
import hudson.model.Run;
import hudson.plugins.analysis.core.BuildHistory;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.pmd.Messages;
import hudson.plugins.pmd.PmdDescriptor;
import hudson.plugins.pmd.PmdResultAction;
import hudson.plugins.pmd.parser.Bug;

public class PmdResult
extends BuildResult {
    private static final long serialVersionUID = 2768250056765266658L;

    public PmdResult(Run<?, ?> build, String defaultEncoding, ParserResult result, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference) {
        this(build, defaultEncoding, result, usePreviousBuildAsReference, useStableBuildAsReference, PmdResultAction.class);
    }

    protected PmdResult(Run<?, ?> build, String defaultEncoding, ParserResult result, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference, Class<? extends ResultAction<PmdResult>> actionType) {
        this(build, new BuildHistory(build, actionType, usePreviousBuildAsReference, useStableBuildAsReference), result, defaultEncoding, true);
    }

    PmdResult(Run<?, ?> build, BuildHistory history, ParserResult result, String defaultEncoding, boolean canSerialize) {
        super(build, history, result, defaultEncoding);
        if (canSerialize) {
            this.serializeAnnotations(result.getAnnotations());
        }
    }

    public String getHeader() {
        return Messages.PMD_ResultAction_Header();
    }

    protected void configure(XStream xstream) {
        xstream.alias("bug", Bug.class);
    }

    public String getSummary() {
        return "PMD: " + PmdResult.createDefaultSummary((String)PmdDescriptor.RESULT_URL, (int)this.getNumberOfAnnotations(), (int)this.getNumberOfModules());
    }

    protected String createDeltaMessage() {
        return PmdResult.createDefaultDeltaMessage((String)PmdDescriptor.RESULT_URL, (int)this.getNumberOfNewWarnings(), (int)this.getNumberOfFixedWarnings());
    }

    protected String getSerializationFileName() {
        return "pmd-warnings.xml";
    }

    public String getDisplayName() {
        return Messages.PMD_ProjectAction_Name();
    }

    protected Class<? extends ResultAction<? extends BuildResult>> getResultActionType() {
        return PmdResultAction.class;
    }
}

