/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Label;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.plugins.perforce.PerforceSCM;
import hudson.scm.AbstractScmTagAction;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PerforceTagAction
extends AbstractScmTagAction {
    private final int changeNumber;
    private Depot depot;
    private String tag;
    private String desc;
    private String view;
    private String owner;

    public PerforceTagAction(AbstractBuild build, Depot depot, int changeNumber, String views, String owner) {
        super(build);
        this.depot = depot;
        this.changeNumber = changeNumber;
        this.view = views;
        this.owner = owner;
    }

    public PerforceTagAction(AbstractBuild build, Depot depot, String label, String views, String owner) {
        super(build);
        this.depot = depot;
        this.changeNumber = -1;
        this.tag = label;
        this.view = views;
        this.owner = owner;
    }

    public PerforceTagAction(PerforceTagAction tga) {
        super(tga.build);
        this.depot = tga.depot;
        this.changeNumber = tga.changeNumber;
        this.tag = tga.tag;
        this.view = tga.view;
        this.owner = tga.owner;
    }

    public int getChangeNumber() {
        return this.changeNumber;
    }

    public String getView() {
        return this.view;
    }

    public String getIconFileName() {
        if (this.tag == null && !Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
            return null;
        }
        return "save.gif";
    }

    public String getDisplayName() {
        if (this.isTagged()) {
            return "Perforce Label";
        }
        return "Label This Build";
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public boolean isTagged() {
        return this.tag != null;
    }

    public String isInvalidTag(String tag) {
        Pattern spaces = Pattern.compile("\\s{1,}");
        Matcher m = spaces.matcher(tag);
        if (m.find()) {
            return "Spaces are not allowed.";
        }
        return null;
    }

    public synchronized FormValidation doCheckTag(@QueryParameter String value) {
        String error;
        String string = error = (value = Util.fixNull((String)value).trim()).length() > 0 ? this.isInvalidTag(value) : null;
        if (error != null) {
            return FormValidation.error((String)error);
        }
        return FormValidation.ok();
    }

    public synchronized void doSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        String tag = req.getParameter("name");
        String desc = req.getParameter("desc");
        this.owner = req.getParameter("owner");
        this.tagBuild(tag, desc);
        rsp.sendRedirect(".");
    }

    public void tagBuild(String tagname, String description) throws IOException {
        this.tag = tagname;
        this.desc = description;
        Label label = new Label();
        label.setName(this.tag);
        label.setDescription(this.desc);
        label.setRevision(new Integer(this.changeNumber).toString());
        if (this.owner != null && !this.owner.equals("")) {
            label.setOwner(this.owner);
        }
        if (this.getBuild().getProject().getScm() instanceof PerforceSCM) {
            PerforceSCM scm = (PerforceSCM)this.getBuild().getProject().getScm();
            this.depot.setPassword(scm.getDecryptedP4Passwd(this.getBuild().getProject()));
        }
        List<String> viewPairs = PerforceSCM.parseProjectPath(this.view, "workspace");
        for (int i = 0; i < viewPairs.size(); i += 2) {
            String depotPath = viewPairs.get(i);
            label.addView(depotPath);
        }
        try {
            this.depot.getLabels().saveLabel(label);
        }
        catch (PerforceException e) {
            this.tag = null;
            this.desc = null;
            e.printStackTrace();
            throw new IOException("Failed to issue perforce label." + e.getMessage());
        }
        this.build.save();
    }
}

