/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce.utils;

import hudson.EnvVars;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.plugins.perforce.PerforceSCM;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeSubstitutionHelper {
    private static final Logger LOGGER = Logger.getLogger(PerforceSCM.class.getName());

    static void getDefaultNodeSubstitutions(@Nonnull PerforceSCM instance, @CheckForNull Node node, @Nonnull Map<String, String> target) throws InterruptedException {
        for (NodeProperty globalNodeProperty : Hudson.getInstance().getGlobalNodeProperties()) {
            if (!(globalNodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
            target.putAll((Map<String, String>)((EnvironmentVariablesNodeProperty)globalNodeProperty).getEnvVars());
        }
        if (node != null) {
            for (NodeProperty nodeProperty : node.getNodeProperties()) {
                if (!(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
                target.putAll((Map<String, String>)((EnvironmentVariablesNodeProperty)nodeProperty).getEnvVars());
            }
            String nodeName = node.getNodeName();
            target.put("nodename", nodeName);
            target.put("hostname", NodeSubstitutionHelper.getHostName(node));
            target.put("hash", NodeSubstitutionHelper.getNodeHash(node));
            target.put("NODE_NAME", nodeName.isEmpty() ? "master" : nodeName);
            target.put("NODE_LABELS", Util.join((Collection)node.getAssignedLabels(), (String)" "));
            Computer c = node.toComputer();
            if (c != null) {
                try {
                    EnvVars env = c.getEnvironment().overrideAll(target);
                    target.putAll((Map<String, String>)env);
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
    }

    @Nonnull
    private static String getNodeHash(@Nonnull Node node) {
        return String.valueOf(node.getNodeName().hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static String getHostName(@Nonnull Node node) throws InterruptedException {
        String host = null;
        try {
            Computer c = node.toComputer();
            if (c != null) {
                host = c.getHostName();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (host == null) {
                LOGGER.log(Level.FINE, "Could not get hostname for slave " + node.getDisplayName());
                host = "UNKNOWNHOST";
            }
        }
        if (host.contains(".")) {
            host = String.valueOf(host.subSequence(0, host.indexOf(46)));
        }
        return host;
    }
}

