/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.parse;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Changelist;
import com.tek42.perforce.parse.Builder;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangelistBuilder
implements Builder<Changelist> {
    private final Logger logger = LoggerFactory.getLogger((String)"perforce");
    private int maxFiles;
    @CheckForNull
    private final Depot depot;
    private static final SimpleDateFormat dateParser = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss ZZZZZ", Locale.ENGLISH);

    public ChangelistBuilder(int maxFiles) {
        this(maxFiles, null);
    }

    public ChangelistBuilder(int maxFiles, Depot depot) {
        this.maxFiles = maxFiles;
        this.depot = depot;
    }

    @Override
    public String[] getBuildCmd(String p4exe, String id) {
        return new String[]{p4exe, "describe", "-s", id};
    }

    @Override
    public Changelist build(StringBuilder sb) throws PerforceException {
        Changelist change = null;
        StringTokenizer lines = new StringTokenizer(sb.toString(), "\n\r");
        try {
            while (lines.hasMoreElements()) {
                String line = lines.nextToken();
                this.logger.debug("Line: " + line);
                if (line.startsWith("Change")) {
                    String serverTimezone;
                    this.logger.debug("New changelist.");
                    change = new Changelist();
                    StringTokenizer details = new StringTokenizer(line);
                    details.nextToken();
                    change.setChangeNumber(new Integer(details.nextToken()));
                    details.nextToken();
                    String user = details.nextToken();
                    change.setUser(user.substring(0, user.indexOf("@")));
                    change.setWorkspace(user.substring(user.indexOf("@") + 1));
                    details.nextToken();
                    String date = details.nextToken();
                    String time = details.nextToken();
                    String string = serverTimezone = this.depot != null ? this.depot.getServerTimezone() : null;
                    if (serverTimezone != null) {
                        change.setDate(ChangelistBuilder.parseDateWithTimezone(date + " " + time + " " + serverTimezone));
                    } else {
                        change.setDate(ChangelistBuilder.parseDate(date + " " + time));
                    }
                    StringBuilder desc = new StringBuilder();
                    line = lines.nextToken();
                    while (line != null && !line.startsWith("Affected files") && !line.startsWith("Jobs fixed")) {
                        this.logger.debug("Description Line: " + line.trim());
                        desc.append(line + "\n");
                        line = lines.nextToken();
                    }
                    change.setDescription(desc.toString().trim());
                }
                if (line.startsWith("Jobs fixed")) {
                    this.logger.debug("Has jobs.");
                    ArrayList<Changelist.JobEntry> jobs = new ArrayList<Changelist.JobEntry>();
                    boolean getDesc = false;
                    Changelist.JobEntry job = new Changelist.JobEntry();
                    String description = null;
                    line = lines.nextToken();
                    while (!line.startsWith("Affected files")) {
                        this.logger.debug("Job Line: " + line);
                        if (!getDesc) {
                            StringTokenizer details = new StringTokenizer(line);
                            job = new Changelist.JobEntry();
                            if (details.hasMoreTokens()) {
                                job.setJob(details.nextToken());
                            } else {
                                this.logger.error("We shouldnt be here.  Should be getting job but no nextToken: " + line);
                            }
                            if (details.hasMoreTokens()) {
                                details.nextToken();
                            } else {
                                this.logger.error("We shouldnt be here.  Should be popping off on but no nextToken: " + line);
                            }
                            if (details.hasMoreTokens()) {
                                details.nextToken();
                            } else {
                                this.logger.error("We shouldnt be here.  Should be popping off date but no nextToken: " + line);
                            }
                            String status = "";
                            if (details.hasMoreTokens()) {
                                String possibleUser = details.nextToken();
                                if ("by".equals(possibleUser)) {
                                    if (details.hasMoreTokens()) {
                                        details.nextToken();
                                    } else {
                                        this.logger.error("We shouldnt be here.  Should be popping off user since found by but no nextToken: " + line);
                                    }
                                    if (details.hasMoreTokens()) {
                                        status = details.nextToken();
                                    }
                                } else {
                                    status = possibleUser;
                                }
                            }
                            job.setStatus(status);
                            getDesc = true;
                            line = lines.nextToken();
                            continue;
                        }
                        description = "";
                        while (line.startsWith("\t") || line.length() == 0) {
                            description = description + line;
                            if (!lines.hasMoreElements()) {
                                this.logger.error("We shouldnt be here.  We are not out of getting the description for the job but no more lines");
                                break;
                            }
                            description = description + "\n";
                            line = lines.nextToken();
                        }
                        job.setDescription(description.trim());
                        jobs.add(job);
                        getDesc = false;
                    }
                    change.setJobs(jobs);
                }
                if (!line.startsWith("Affected files")) continue;
                this.logger.debug("reading files...");
                ArrayList<Changelist.FileEntry> files = new ArrayList<Changelist.FileEntry>();
                int fileCount = 0;
                while (lines.hasMoreElements()) {
                    if (this.maxFiles > 0) {
                        if (fileCount >= this.maxFiles) break;
                        ++fileCount;
                    }
                    String entry = lines.nextToken();
                    this.logger.debug("File Line: " + entry);
                    int revStart = entry.indexOf("#");
                    if (revStart < 0) continue;
                    String filename = entry.substring(4, revStart);
                    String rev = entry.substring(revStart + 1, entry.indexOf(" ", revStart));
                    String action = entry.substring(entry.indexOf(" ", revStart) + 1);
                    action = action.replace('/', '_');
                    Changelist.FileEntry file = new Changelist.FileEntry();
                    file.setFilename(filename);
                    file.setRevision(rev);
                    file.setChangenumber(Integer.valueOf(change.getChangeNumber()).toString());
                    file.setAction(Changelist.FileEntry.Action.valueOf(action.toUpperCase(Locale.US)));
                    files.add(file);
                }
                change.setFiles(files);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception: " + e.getMessage());
            throw new PerforceException("Failed to retrieve changelist.\nResponse from perforce was:\n" + sb, e);
        }
        return change;
    }

    @Override
    public String[] getSaveCmd(String p4exe, Changelist obj) {
        return new String[]{p4exe, "change", "-i"};
    }

    @Override
    public boolean requiresStandardInput() {
        return true;
    }

    @Override
    public void save(Changelist obj, Writer out) throws PerforceException {
        throw new UnsupportedOperationException("This is not implemented.");
    }

    private static Date parseDateWithTimezone(String newDate) throws PerforceException {
        try {
            return dateParser.parse(newDate);
        }
        catch (ParseException e) {
            throw new PerforceException("Cannot parse changelist timestamp : " + newDate, e);
        }
    }

    public static Date parseDate(String newDate) {
        if (newDate == null || newDate.equals("")) {
            return null;
        }
        String[] parts = newDate.split(" ");
        String[] date = parts[0].split("/");
        String[] time = null;
        if (parts.length > 1) {
            time = parts[1].split(":");
            time[2] = time[2].replaceAll("\\.0", "");
        } else {
            time = "00:00:00".split(":");
        }
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance();
        cal.clear();
        cal.set(new Integer(date[0]), new Integer(date[1]) - 1, new Integer(date[2]), new Integer(time[0]), new Integer(time[1]), new Integer(time[2]));
        return cal.getTime();
    }
}

