/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Label;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.plugins.perforce.PerforceSCM;
import hudson.scm.AbstractScmTagAction;
import hudson.security.Permission;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceTagAction
extends AbstractScmTagAction {
    private final int changeNumber;
    private Depot depot;
    private List<PerforceTag> tags = new ArrayList<PerforceTag>();
    @Deprecated
    private transient String tag;
    @Deprecated
    private transient String desc;
    private String view;
    private String owner;

    public PerforceTagAction(AbstractBuild build, Depot depot, int changeNumber, String views, String owner) {
        super(build);
        this.depot = depot;
        this.changeNumber = changeNumber;
        this.view = views;
        this.owner = owner;
    }

    public PerforceTagAction(AbstractBuild build, Depot depot, String label, String views, String owner) {
        super(build);
        this.depot = depot;
        this.changeNumber = -1;
        this.tag = label;
        this.tags.add(new PerforceTag(label, ""));
        this.view = views;
        this.owner = owner;
    }

    public PerforceTagAction(PerforceTagAction tga) {
        super(tga.build);
        this.depot = tga.depot;
        this.changeNumber = tga.changeNumber;
        this.tag = tga.tag;
        this.tags.addAll(tga.getTags());
        this.view = tga.view;
        this.owner = tga.owner;
    }

    public int getChangeNumber() {
        return this.changeNumber;
    }

    public String getView() {
        return this.view;
    }

    public String getIconFileName() {
        if (!this.getACL().hasPermission(this.getPermission())) {
            return null;
        }
        return "save.gif";
    }

    public String getDisplayName() {
        if (this.isTagged()) {
            return "Perforce Label";
        }
        return "Label This Build";
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Depot getDepot() {
        return this.depot;
    }

    public List<PerforceTag> getTags() {
        return this.tags;
    }

    public void setTags(List<PerforceTag> tags) {
        this.tags = tags;
    }

    public boolean isTagged() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public String isInvalidTag(String tag) {
        Pattern spaces = Pattern.compile("\\s{1,}");
        Matcher m = spaces.matcher(tag);
        if (m.find()) {
            return "Spaces are not allowed.";
        }
        return null;
    }

    public synchronized FormValidation doCheckTag(@QueryParameter String value) {
        String error;
        String string = error = (value = Util.fixNull((String)value).trim()).length() > 0 ? this.isInvalidTag(value) : null;
        if (error != null) {
            return FormValidation.error((String)error);
        }
        return FormValidation.ok();
    }

    public synchronized void doSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.getACL().checkPermission(this.getPermission());
        String tag = req.getParameter("name");
        String desc = req.getParameter("desc");
        this.owner = req.getParameter("owner");
        this.tagBuild(tag, desc);
        rsp.sendRedirect(".");
    }

    public void tagBuild(String tagname, String description) throws IOException {
        Label label = new Label();
        label.setName(tagname);
        label.setDescription(description);
        label.setRevision(new Integer(this.changeNumber).toString());
        if (this.owner != null && !this.owner.equals("")) {
            label.setOwner(this.owner);
        }
        if (this.getBuild().getProject().getScm() instanceof PerforceSCM) {
            PerforceSCM scm = (PerforceSCM)this.getBuild().getProject().getScm();
            this.depot.setPassword(scm.getDecryptedP4Passwd(this.getBuild().getProject()));
        }
        List<String> viewPairs = PerforceSCM.parseProjectPath(this.view, "workspace");
        for (int i = 0; i < viewPairs.size(); i += 2) {
            String depotPath = viewPairs.get(i);
            label.addView(depotPath);
        }
        try {
            this.depot.getLabels().saveLabel(label);
        }
        catch (PerforceException e) {
            e.printStackTrace();
            throw new IOException("Failed to issue perforce label." + e.getMessage());
        }
        this.tags.add(new PerforceTag(tagname, description));
        this.build.save();
    }

    public Object readResolve() {
        if (this.tags == null) {
            this.tags = new ArrayList<PerforceTag>();
            if (this.tag != null) {
                this.tags.add(new PerforceTag(this.tag, this.desc));
            }
        }
        return this;
    }

    protected Permission getPermission() {
        return PerforceSCM.TAG;
    }

    public static class PerforceTag {
        private String name;
        private String desc;

        public PerforceTag(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

