/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import hudson.EnvVars;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Descriptor;
import hudson.model.EnvironmentSpecific;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PerforceToolInstallation
extends ToolInstallation
implements NodeSpecific<PerforceToolInstallation>,
EnvironmentSpecific<PerforceToolInstallation> {
    static transient ArrayList<PerforceToolInstallation> p4Tools = new ArrayList();

    @DataBoundConstructor
    public PerforceToolInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public String getP4Exe() {
        return this.getHome();
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void onLoaded() {
        DescriptorImpl descriptor = (DescriptorImpl)Hudson.getInstance().getDescriptor(PerforceToolInstallation.class);
        PerforceToolInstallation[] installations = descriptor.getInstallations();
        if (installations.length > 0) {
            return;
        }
        if (!p4Tools.isEmpty()) {
            ((DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class)).setInstallations(p4Tools.toArray(new PerforceToolInstallation[p4Tools.size()]));
        }
    }

    public static synchronized void migrateOldData(String exe) {
        for (PerforceToolInstallation tool : p4Tools) {
            if (File.separatorChar == '/' && tool.getName().equals(exe)) {
                return;
            }
            if (File.separatorChar == '/' || !tool.getName().equalsIgnoreCase(exe)) continue;
            return;
        }
        p4Tools.add(new PerforceToolInstallation(exe, exe, Collections.emptyList()));
    }

    public PerforceToolInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new PerforceToolInstallation(this.getName(), this.translateFor(node, log), Collections.emptyList());
    }

    public PerforceToolInstallation forEnvironment(EnvVars environment) {
        return new PerforceToolInstallation(this.getName(), environment.expand(this.getHome()), Collections.emptyList());
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptor(PerforceToolInstallation.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<PerforceToolInstallation> {
        private volatile PerforceToolInstallation[] installations = new PerforceToolInstallation[0];

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Perforce";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            super.configure(req, json);
            this.save();
            return true;
        }

        public PerforceToolInstallation[] getInstallations() {
            return this.installations;
        }

        public void setInstallations(PerforceToolInstallation ... installations) {
            this.installations = installations;
            this.save();
        }

        public FormValidation doCheckHome(@QueryParameter File value) throws IOException, ServletException {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            String path = value.getPath();
            return FormValidation.validateExecutable((String)path);
        }
    }
}

