/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.parse;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Workspace;
import com.tek42.perforce.parse.AbstractPerforceTemplate;
import com.tek42.perforce.parse.WorkspaceBuilder;
import java.util.ArrayList;

public class Workspaces
extends AbstractPerforceTemplate {
    public Workspaces(Depot depot) {
        super(depot);
    }

    public Workspace getWorkspace(String name) throws PerforceException {
        WorkspaceBuilder builder = new WorkspaceBuilder();
        Workspace workspace = (Workspace)builder.build(this.getPerforceResponse(builder.getBuildCmd(this.getP4Exe(), name)));
        if (workspace == null) {
            throw new PerforceException("Failed to retrieve workspace: " + name);
        }
        return workspace;
    }

    public void saveWorkspace(Workspace workspace) throws PerforceException {
        WorkspaceBuilder builder = new WorkspaceBuilder();
        this.saveToPerforce(workspace, builder);
    }

    public StringBuilder syncToHead(String path) throws PerforceException {
        return this.syncToHead(path, false);
    }

    public StringBuilder syncToHead(String path, boolean forceSync) throws PerforceException {
        if (!path.endsWith("#head")) {
            path = path + "#head";
        }
        return this.syncTo(path, forceSync, false);
    }

    public StringBuilder syncTo(String path, boolean forceSync, boolean populateOnly) throws PerforceException {
        final StringBuilder errors = new StringBuilder();
        AbstractPerforceTemplate.ResponseFilter filter = new AbstractPerforceTemplate.ResponseFilter(){
            private int count = 0;

            public boolean accept(String line) {
                ++this.count;
                if (line.contains("Request too large")) {
                    return true;
                }
                if (line.startsWith("error:") && !line.contains("file(s) up-to-date.")) {
                    errors.append(line);
                    errors.append("\n");
                }
                return this.count < 50;
            }
        };
        path = path.replaceAll("\"", "");
        ArrayList<String> cmdLineList = new ArrayList<String>();
        cmdLineList.add(this.getP4Exe());
        cmdLineList.add("-s");
        cmdLineList.add("sync");
        if (forceSync) {
            cmdLineList.add("-f");
        }
        if (populateOnly) {
            cmdLineList.add("-p");
        }
        cmdLineList.add(path);
        String[] cmdLine = cmdLineList.toArray(new String[cmdLineList.size()]);
        StringBuilder response = this.getPerforceResponse(cmdLine, filter);
        if (this.hitMax(response)) {
            throw new PerforceException("Hit perforce server limit while " + (forceSync ? "force " : "") + "syncing: \n" + response);
        }
        if (errors.length() > 0) {
            throw new PerforceException("Errors encountered while " + (forceSync ? "force " : "") + "syncing: " + errors.toString());
        }
        return response;
    }

    public StringBuilder flushTo(String path) throws PerforceException {
        StringBuilder response = this.getPerforceResponse(new String[]{this.getP4Exe(), "sync", "-k", path});
        if (this.hitMax(response)) {
            throw new PerforceException("Hit perforce server limit while flushing client: " + response);
        }
        return response;
    }

    public StringBuilder syncDryRun() throws PerforceException {
        StringBuilder result = this.getPerforceResponse(new String[]{this.getP4Exe(), "sync", "-n"});
        return result;
    }
}

