/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce.browsers;

import com.tek42.perforce.model.Changelist;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.plugins.perforce.PerforceChangeLogEntry;
import hudson.plugins.perforce.PerforceRepositoryBrowser;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class P4Web
extends PerforceRepositoryBrowser {
    public final URL url;
    public final String p4WebEndShite = "?ac=22";
    public final String p4DifEndShite = "?ac=19";
    public final String p4ClEndShite = "?ac=10";
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public P4Web(URL url) throws MalformedURLException {
        this.url = P4Web.normalizeToEndWithSlash((URL)url);
    }

    public URL getDiffLink(Changelist.FileEntry file) throws IOException {
        if (file.getAction() != Changelist.FileEntry.Action.EDIT && file.getAction() != Changelist.FileEntry.Action.INTEGRATE) {
            return null;
        }
        int r = new Integer(file.getRevision());
        if (r <= 1) {
            return null;
        }
        return new URL(this.url.toString() + file.getFilename() + "?ac=19" + "&rev1=" + (r - 1) + "&rev2=" + r);
    }

    public URL getFileLink(Changelist.FileEntry file) throws IOException {
        return new URL(this.url.toString() + file.getFilename() + "?ac=22");
    }

    public URL getChangeSetLink(PerforceChangeLogEntry changeSet) throws IOException {
        return new URL(this.url.toString() + changeSet.getChange().getChangeNumber() + "?ac=10");
    }

    public URL getURL() {
        return this.url;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "P4Web";
        }

        public FormValidation doCheck(final StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    String host = Util.fixEmpty((String)req.getParameter("url"));
                    String user = Util.fixEmpty((String)req.getParameter("user"));
                    String pass = Util.fixEmpty((String)req.getParameter("pass"));
                    if (host == null) {
                        return FormValidation.ok();
                    }
                    if (!host.endsWith("/")) {
                        host = host + '/';
                    }
                    if (!host.startsWith("http://") && !host.startsWith("https://")) {
                        return FormValidation.errorWithMarkup((String)"The URL should contain <tt>http://</tt> or <tt>https://</tt>");
                    }
                    return FormValidation.ok();
                }
            }.check();
        }

        public P4Web newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (P4Web)((Object)req.bindParameters(P4Web.class, "p4web."));
        }
    }
}

