/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.parse;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Changelist;
import com.tek42.perforce.model.Workspace;
import com.tek42.perforce.parse.AbstractPerforceTemplate;
import com.tek42.perforce.parse.ChangelistBuilder;
import hudson.plugins.perforce.PerforceSCMHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Changes
extends AbstractPerforceTemplate {
    public Changes(Depot depot) {
        super(depot);
    }

    public Changelist getChangelist(int number) throws PerforceException {
        ChangelistBuilder builder = new ChangelistBuilder();
        Changelist change = builder.build(this.getPerforceResponse(builder.getBuildCmd(this.getP4Exe(), Integer.toString(number))));
        if (change == null) {
            throw new PerforceException("Failed to retrieve changelist " + number);
        }
        this.calculateWorkspacePaths(change);
        return change;
    }

    private void calculateWorkspacePaths(Changelist change) throws PerforceException {
        for (Changelist.FileEntry file : change.getFiles()) {
            byte[] bytes = this.getRawPerforceResponseBytes(new String[]{this.getP4Exe(), "-G", "where", file.getFilename()});
            PerforceSCMHelper.WhereMapping map = PerforceSCMHelper.parseWhereMapping(bytes);
            file.setWorkspacePath(map.getWorkspacePath().replaceAll("^//\\S+?/", ""));
        }
    }

    public List<Changelist> getChangelists(String path, int lastChange, int limit) throws PerforceException {
        path = this.normalizePath(path);
        if (lastChange > 0) {
            path = path + "@" + lastChange;
        }
        String[] cmd = limit > 0 ? new String[]{this.getP4Exe(), "changes", "-m", Integer.toString(limit), path} : new String[]{this.getP4Exe(), "changes", path};
        StringBuilder response = this.getPerforceResponse(cmd);
        List<String> ids = this.parseList(response, 1);
        ArrayList<Changelist> changes = new ArrayList<Changelist>();
        for (String id : ids) {
            try {
                changes.add(this.getChangelist(new Integer(id)));
            }
            catch (Exception e) {
                throw new PerforceException("Could not retrieve changelists.\nResponse from perforce was:\n" + response, e);
            }
        }
        return changes;
    }

    public List<Integer> getChangeNumbers(String path, int start, int limit) throws PerforceException {
        String[] cmd;
        StringBuilder response;
        path = this.normalizePath(path);
        if (start > 0) {
            path = path + "@" + start;
        }
        if (this.hitMax(response = this.getPerforceResponse(cmd = limit > 0 ? new String[]{this.getP4Exe(), "changes", "-m", Integer.toString(limit), path} : new String[]{this.getP4Exe(), "changes", path}))) {
            throw new PerforceException("Hit perforce server limit while pulling changes: " + response);
        }
        List<String> ids = this.parseList(response, 1);
        ArrayList<Integer> numbers = new ArrayList<Integer>(ids.size());
        for (String id : ids) {
            try {
                numbers.add(new Integer(id));
            }
            catch (Exception e) {
                throw new PerforceException("Failed to get change numbers.\nResponse from perforce was:\n" + response, e);
            }
        }
        return numbers;
    }

    public List<Integer> getChangeNumbersTo(String path, int untilChange) throws PerforceException {
        return this.getChangeNumbersTo(null, path, untilChange);
    }

    public List<Integer> getChangeNumbersTo(String workspace, String path, int untilChange) throws PerforceException {
        String DELIM = " ";
        int MAX_PATHS_SUPPORTED_PER_COMMAND = 1;
        StringTokenizer allPaths = new StringTokenizer(path, DELIM);
        ArrayList<String> supportedPaths = new ArrayList<String>();
        StringBuilder currentPaths = new StringBuilder("");
        int numberOfPathsInCurrentPaths = 0;
        while (true) {
            if (!allPaths.hasMoreTokens()) {
                if (currentPaths.length() <= 0) break;
                supportedPaths.add(currentPaths.toString().trim());
                break;
            }
            String nextPath = allPaths.nextToken();
            currentPaths.append(nextPath + " ");
            if (++numberOfPathsInCurrentPaths != MAX_PATHS_SUPPORTED_PER_COMMAND) continue;
            supportedPaths.add(currentPaths.toString().trim());
            currentPaths.setLength(0);
            numberOfPathsInCurrentPaths = 0;
        }
        HashSet<Integer> uniqueIds = new HashSet<Integer>();
        for (String pathToUse : supportedPaths) {
            List<Integer> ids = this.getChangeNumbersToForSinglePath(workspace, pathToUse, untilChange);
            uniqueIds.addAll(ids);
        }
        ArrayList<Integer> sortedIds = new ArrayList<Integer>(uniqueIds);
        Collections.sort(sortedIds, Collections.reverseOrder());
        return sortedIds;
    }

    private List<Integer> getChangeNumbersToForSinglePath(String workspace, String path, int untilChange) throws PerforceException {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        this.recurseGetChangeNumbersTo(workspace, path, untilChange, numbers);
        return numbers;
    }

    private void recurseGetChangeNumbersTo(String workspace, String path, int untilChange, List<Integer> numbers) throws PerforceException {
        path = this.normalizePath(path);
        ArrayList<String> cmdList = new ArrayList<String>();
        this.addCommand(cmdList, this.getP4Exe(), "changes", "-m", "25");
        this.addCommandWorkspace(cmdList, workspace);
        this.addCommand(cmdList, path);
        boolean continueProcessing = true;
        while (continueProcessing) {
            StringBuilder response;
            try {
                response = this.getPerforceResponse(cmdList.toArray(new String[cmdList.size()]));
                if (this.hitMax(response)) {
                    String[] newPaths;
                    for (String newPath : newPaths = this.getTopLevelDirectoriesForPath(workspace, path)) {
                        this.recurseGetChangeNumbersTo(workspace, newPath, untilChange, numbers);
                    }
                    break;
                }
            }
            catch (PerforceException e) {
                if (e.getMessage().startsWith("No output for")) break;
                throw e;
            }
            List<String> temp = this.parseList(response, 1);
            if (temp.size() == 0) break;
            for (String num : temp) {
                if (new Integer(num) >= untilChange) {
                    this.getLogger().warn("num is " + num + " until is " + untilChange);
                    numbers.add(new Integer(num));
                    continue;
                }
                continueProcessing = false;
                break;
            }
            String lastChange = temp.get(temp.size() - 1);
            int next = 0;
            try {
                next = new Integer(lastChange) - 1;
            }
            catch (NumberFormatException nfe) {
                this.getLogger().warn("Unable to parse perforce message.  Expected a number but got " + lastChange);
                this.getLogger().warn("From command " + response.toString());
            }
            cmdList.clear();
            this.getLogger().warn("running p4 changes for " + next + " until change is " + untilChange);
            this.addCommand(cmdList, this.getP4Exe(), "changes", "-m", "25");
            this.addCommandWorkspace(cmdList, workspace);
            this.addCommand(cmdList, path + "@" + next);
        }
    }

    private String[] getTopLevelDirectoriesForPath(String workspace, String path) throws PerforceException {
        if (path.endsWith("...")) {
            path = path.replaceAll("\\.\\.\\.", "\\*");
        }
        ArrayList<String> cmdList = new ArrayList<String>();
        this.addCommand(cmdList, this.getP4Exe(), "dirs");
        this.addCommandWorkspace(cmdList, workspace);
        this.addCommand(cmdList, path);
        StringBuilder response = this.getPerforceResponse(cmdList.toArray(new String[cmdList.size()]));
        List<String> list = this.parseList(response, 0);
        return list.toArray(new String[list.size()]);
    }

    private void addCommandWorkspace(List<String> cmdList, String workspace) {
        if (workspace != null) {
            this.addCommand(cmdList, "-c", workspace);
        }
    }

    private String normalizePath(String path) {
        if (path == null || path.equals("")) {
            path = "//...";
        }
        return path;
    }

    private void addCommand(List<String> list, String ... args) {
        for (String command : args) {
            list.add(command);
        }
    }

    public List<Changelist> getChangelistsFromNumbers(List<Integer> numbers) throws PerforceException {
        ArrayList<Changelist> changes = new ArrayList<Changelist>();
        for (Integer id : numbers) {
            changes.add(this.getChangelist(id));
        }
        return changes;
    }

    public List<Integer> getChangeNumbersInRange(Workspace workspace, int first, int last) throws PerforceException {
        StringBuilder sb = new StringBuilder();
        sb.append("//");
        sb.append(workspace.getName());
        sb.append("/...");
        String path = sb.toString();
        return this.getChangeNumbersInRangeForSinglePath(workspace, first, last, path);
    }

    public List<Integer> getChangeNumbersInRange(Workspace workspace, int first, int last, String paths) throws PerforceException {
        if (paths == null) {
            return this.getChangeNumbersInRange(workspace, first, last);
        }
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (String path : paths.replaceAll("\r", "").split("\n")) {
            List<Integer> newNumbers = this.getChangeNumbersInRangeForSinglePath(workspace, first, last, path);
            for (Integer num : newNumbers) {
                if (numbers.contains(num)) continue;
                numbers.add(num);
            }
        }
        Collections.sort(numbers);
        Collections.reverse(numbers);
        return numbers;
    }

    public List<Integer> getChangeNumbersInRangeForSinglePath(Workspace workspace, int first, int last, String path) throws PerforceException {
        StringBuilder sb = new StringBuilder();
        sb.append(path.replaceAll("\"", ""));
        sb.append("@");
        sb.append(first);
        sb.append(",@");
        sb.append(last);
        String fullPath = sb.toString();
        String[] cmd = new String[]{this.getP4Exe(), "-s", "changes", fullPath};
        List<String> response = this.getRawPerforceResponseLines(cmd);
        ArrayList<Integer> numbers = new ArrayList<Integer>(response.size());
        for (String line : response) {
            if (!line.startsWith("info: Change ")) continue;
            int offset = line.indexOf(32, 13);
            String s = line.substring(13, offset);
            Integer n = Integer.valueOf(s);
            numbers.add(n);
        }
        return numbers;
    }
}

