/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce;

import com.perforce.api.Env;
import com.tek42.perforce.parse.Changes;
import com.tek42.perforce.parse.Counters;
import com.tek42.perforce.parse.Groups;
import com.tek42.perforce.parse.Labels;
import com.tek42.perforce.parse.Status;
import com.tek42.perforce.parse.Users;
import com.tek42.perforce.parse.Workspaces;
import com.tek42.perforce.process.DefaultExecutorFactory;
import com.tek42.perforce.process.Executor;
import com.tek42.perforce.process.ExecutorFactory;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Depot {
    private final transient Logger logger = LoggerFactory.getLogger((String)"perforce");
    private HashMap<String, String> settings = new HashMap();
    private String pathSep;
    private String fileSep;
    private boolean validEnvp;
    private String p4exe;
    private long threshold;
    private String p4Ticket;
    ExecutorFactory execFactory;
    private Changes changes;
    private Workspaces workspaces;
    private Users users;
    private Labels labels;
    private Status status;
    private Groups groups;
    private Counters counters;

    public Depot() {
        this(new DefaultExecutorFactory());
    }

    public Depot(ExecutorFactory factory) {
        this.setUser("robot");
        this.setClient("robot-client");
        this.setPort("localhost:1666");
        this.setPassword("");
        this.setPath("C:\\Program Files\\Perforce");
        this.setenv("CLASSPATH", "/usr/share/java/p4.jar");
        this.setSystemDrive("C:");
        this.setSystemRoot("C:\\WINDOWS");
        this.setExecutable("p4");
        this.setServerTimeout(10000L);
        String os = System.getProperty("os.name");
        if (os == null) {
            return;
        }
        if (os.startsWith("Windows")) {
            this.setenv("PATHEXT", ".COM;.EXE;.BAT;.CMD");
            String windir = System.getProperty("com.ms.windir");
            if (windir != null) {
                this.appendPath(windir.substring(0, 1) + "\\Program Files\\Perforce");
                this.setSystemDrive(windir.substring(0, 1));
                this.setSystemRoot(windir);
            }
        }
        this.execFactory = factory;
        this.validEnvp = false;
    }

    public ExecutorFactory getExecFactory() {
        if (!this.validEnvp) {
            this.execFactory.setEnv(this.settings);
        }
        return this.execFactory;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Env getPerforceEnv() {
        Env env = new Env();
        env.setClient(this.getClient());
        env.setExecutable(this.getExecutable());
        env.setPassword(this.getPassword());
        env.setUser(this.getUser());
        env.setPort(this.getPort());
        env.setSystemDrive(this.getSystemDrive());
        env.setSystemRoot(this.getSystemRoot());
        return env;
    }

    public Changes getChanges() {
        if (this.changes == null) {
            this.changes = new Changes(this);
        }
        return this.changes;
    }

    public Workspaces getWorkspaces() {
        if (this.workspaces == null) {
            this.workspaces = new Workspaces(this);
        }
        return this.workspaces;
    }

    public Users getUsers() {
        if (this.users == null) {
            this.users = new Users(this);
        }
        return this.users;
    }

    public Labels getLabels() {
        if (this.labels == null) {
            this.labels = new Labels(this);
        }
        return this.labels;
    }

    public Groups getGroups() {
        if (this.groups == null) {
            this.groups = new Groups(this);
        }
        return this.groups;
    }

    public Counters getCounters() {
        if (this.counters == null) {
            this.counters = new Counters(this);
        }
        return this.counters;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status(this);
        }
        return this.status;
    }

    public String info() throws Exception {
        String line;
        Executor p4 = this.getExecFactory().newExecutor();
        String[] cmd = new String[]{this.getExecutable(), "info"};
        p4.exec(cmd);
        StringBuilder sb = new StringBuilder();
        while ((line = p4.getReader().readLine()) != null) {
            sb.append(line + "\n");
        }
        return sb.toString();
    }

    public String getProperty(String key) {
        return this.settings.get(key);
    }

    public String getProperty(String key, String def) {
        String value = this.getProperty(key);
        if (value == null || value.equals("")) {
            return def;
        }
        return value;
    }

    public void setUser(String user) {
        this.setenv("P4USER", user);
    }

    public String getUser() {
        return this.settings.get("P4USER");
    }

    public void setClient(String client) {
        this.setenv("P4CLIENT", client);
    }

    public String getClient() {
        return this.settings.get("P4CLIENT");
    }

    public void setPort(String port) {
        this.setenv("P4PORT", port);
    }

    public String getPort() {
        return this.settings.get("P4PORT");
    }

    public void setPassword(String password) {
        this.setenv("P4PASSWD", password);
    }

    public String getPassword() {
        return this.settings.get("P4PASSWD");
    }

    public void setPath(String path) {
        this.setenv("PATH", path);
    }

    public String getCharset() {
        return this.settings.get("P4CHARSET");
    }

    public void setCharset(String charset) {
        this.setenv("P4CHARSET", charset);
    }

    public String getCommandCharset() {
        return this.settings.get("P4COMMANDCHARSET");
    }

    public void setCommandCharset(String charset) {
        this.setenv("P4COMMANDCHARSET", charset);
    }

    public void appendPath(String path) {
        if (null == path) {
            return;
        }
        String origPath = this.getProperty("PATH");
        if (null == this.pathSep || null == origPath) {
            this.setPath(path);
            return;
        }
        StringTokenizer st = new StringTokenizer(origPath, this.pathSep);
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals(path)) {
                return;
            }
            sb.append(tok);
            sb.append(this.pathSep);
        }
        sb.append(path);
        this.setPath(path);
    }

    public String getPath() {
        return this.settings.get("PATH");
    }

    public void setSystemDrive(String drive) {
        this.setenv("SystemDrive", drive);
    }

    public String getSystemDrive() {
        return this.settings.get("SystemDrive");
    }

    public void setSystemRoot(String root) {
        this.setenv("SystemRoot", root);
    }

    public String getSystemRoot() {
        return this.settings.get("SystemRoot");
    }

    public void setExecutable(String exe) {
        int pos;
        if (null == exe) {
            return;
        }
        this.p4exe = exe;
        if (null == this.fileSep) {
            this.fileSep = System.getProperties().getProperty("file.separator", "\\");
        }
        if (-1 == (pos = exe.lastIndexOf(this.fileSep))) {
            return;
        }
        if (null == this.pathSep) {
            this.pathSep = System.getProperties().getProperty("path.separator", ";");
        }
        this.appendPath(exe.substring(0, pos));
    }

    public String getExecutable() {
        return this.p4exe;
    }

    public void setServerTimeout(long threshold) {
        this.threshold = threshold;
    }

    public long getServerTimeout() {
        return this.threshold;
    }

    public String getP4Ticket() {
        return this.p4Ticket;
    }

    public void setP4Ticket(String ticket) {
        this.p4Ticket = ticket;
    }

    private void setenv(String key, String newValue) {
        String currentValue;
        if (newValue != null && (newValue = newValue.trim()).length() == 0) {
            newValue = null;
        }
        if (Depot.safeEquals(newValue, currentValue = this.settings.get(key))) {
            return;
        }
        if (newValue == null) {
            this.settings.remove(key);
        } else {
            this.settings.put(key, newValue);
        }
        this.validEnvp = false;
    }

    public static boolean safeEquals(String newValue, String currentValue) {
        if (newValue == null) {
            return currentValue == null;
        }
        return newValue.equals(currentValue);
    }
}

