/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.monitoring;

import hudson.Plugin;
import hudson.init.InitMilestone;
import hudson.util.PluginServletFilter;
import java.io.File;
import java.util.Arrays;
import java.util.logging.LogRecord;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import jenkins.model.Jenkins;
import net.bull.javamelody.Parameter;
import org.jvnet.hudson.plugins.monitoring.HudsonMonitoringFilter;

public class PluginImpl
extends Plugin {
    private ServletContext context;
    private HudsonMonitoringFilter filter;

    public void start() throws Exception {
        super.start();
        final Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            this.context = jenkins.servletContext;
            Thread thread = new Thread("javamelody-initializer"){

                @Override
                public void run() {
                    while (jenkins.getInitLevel() != InitMilestone.COMPLETED) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (jenkins.isUseCrumbs()) {
                        Parameter.CSRF_PROTECTION_ENABLED.setValue("true");
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
        if (this.isParameterUndefined(Parameter.SYSTEM_ACTIONS_ENABLED)) {
            Parameter.SYSTEM_ACTIONS_ENABLED.setValue("true");
        }
        if (this.isParameterUndefined(Parameter.NO_DATABASE)) {
            Parameter.NO_DATABASE.setValue("true");
        }
        if (this.isParameterUndefined(Parameter.STORAGE_DIRECTORY)) {
            Parameter.STORAGE_DIRECTORY.setValue("/" + new File(jenkins.getRootDir(), "monitoring").getAbsolutePath());
        }
        if (this.isParameterUndefined("javamelody.analytics-disabled") && this.isParameterUndefined(Parameter.ANALYTICS_ID)) {
            Parameter.ANALYTICS_ID.setValue("UA-1335263-7");
        }
        if (this.isParameterUndefined(Parameter.HTTP_TRANSFORM_PATTERN)) {
            Parameter.HTTP_TRANSFORM_PATTERN.setValue("/\\d+/|/site/.+|avadoc/.+|/ws/.+|obertura/.+|estReport/.+|iolations/file/.+|/user/.+|/static/\\w+/|/adjuncts/\\w+/|/bound/[\\w\\-]+");
        }
        if (this.isParameterUndefined(Parameter.CUSTOM_REPORTS)) {
            Parameter.CUSTOM_REPORTS.setValue("Jenkins Info,About Monitoring");
            System.setProperty("javamelody.Jenkins Info", "/systemInfo");
            System.setProperty("javamelody.About Monitoring", "https://wiki.jenkins-ci.org/display/JENKINS/Monitoring");
        }
        if (this.isParameterUndefined(Parameter.GZIP_COMPRESSION_DISABLED)) {
            Parameter.GZIP_COMPRESSION_DISABLED.setValue("true");
        }
        if (this.isParameterUndefined(Parameter.MAVEN_REPOSITORIES)) {
            String mavenRepositories = System.getProperty("user.home") + "/.m2/repository,http://repo1.maven.org/maven2,http://repo.jenkins-ci.org/public";
            Parameter.MAVEN_REPOSITORIES.setValue(mavenRepositories);
        }
        Arrays.hashCode(new Class[]{LogRecord.class});
        this.filter = new HudsonMonitoringFilter();
        PluginServletFilter.addFilter((Filter)this.filter);
    }

    private boolean isParameterUndefined(Parameter parameter) {
        String key = "javamelody." + parameter.getCode();
        return this.isParameterUndefined(key);
    }

    private boolean isParameterUndefined(String key) {
        return System.getProperty(key) == null && this.context != null && this.context.getInitParameter(key) == null;
    }

    HudsonMonitoringFilter getFilter() {
        return this.filter;
    }

    public void postInitialize() throws Exception {
        super.postInitialize();
        if (this.filter == null) {
            throw new Exception("Post-initialization hook has been called before the plugin start. Filters are not available");
        }
        this.filter.getNodesCollector().init();
    }

    public void stop() throws Exception {
        if (this.filter != null && this.filter.getNodesCollector() != null) {
            this.filter.getNodesCollector().stop();
        }
        super.stop();
    }
}

