/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import hudson.model.Computer;
import hudson.remoting.Callable;
import hudson.remoting.Future;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.Action;
import net.bull.javamelody.internal.model.HeapHistogram;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.MBeanNode;
import net.bull.javamelody.internal.model.MBeans;
import net.bull.javamelody.internal.model.ProcessInformations;
import net.bull.javamelody.internal.model.VirtualMachine;

final class RemoteCallHelper {
    private static final MasterToSlaveCallable<JavaInformations, Throwable> JAVA_INFORMATIONS_TASK = new JavaInformationsTask();
    private static final MasterToSlaveCallable<HeapHistogram, Throwable> HEAP_HISTOGRAM_TASK = new HeapHistogramTask();
    private static final MasterToSlaveCallable<List<ProcessInformations>, Throwable> PROCESS_INFORMATIONS_TASK = new ProcessInformationsTask();
    private static final MasterToSlaveCallable<List<MBeanNode>, Throwable> MBEANS_TASK = new MBeansTask();
    private final String nodeName;

    RemoteCallHelper(String nodeName) {
        this.nodeName = nodeName;
    }

    private <T> Map<String, T> collectDataByNodeName(Callable<T, Throwable> task) throws IOException {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return Collections.emptyMap();
        }
        Computer[] computers = jenkins.getComputers();
        LinkedHashMap<String, Future> futuresByNodeName = new LinkedHashMap<String, Future>(computers.length);
        DelegatingTask<T> delegatingTask = new DelegatingTask<T>(task);
        for (Computer c : computers) {
            if (!c.isOnline() || this.nodeName != null && !this.nodeName.equals(c.getName())) continue;
            futuresByNodeName.put(c.getName(), c.getChannel().callAsync(delegatingTask));
        }
        long now = System.currentTimeMillis();
        long end = now + TimeUnit.SECONDS.toMillis(59L);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(futuresByNodeName.size());
        for (Map.Entry entry : futuresByNodeName.entrySet()) {
            String node = (String)entry.getKey();
            Future future = (Future)entry.getValue();
            long timeout = Math.max(0L, end - System.currentTimeMillis());
            try {
                result.put(node, future.get(timeout, TimeUnit.MILLISECONDS));
            }
            catch (TimeoutException e) {
            }
            catch (Throwable e) {}
        }
        return result;
    }

    Map<String, JavaInformations> collectJavaInformationsListByName() throws IOException {
        return this.collectDataByNodeName((Callable)JAVA_INFORMATIONS_TASK);
    }

    List<String> collectJmxValues(String jmxValueParameter) throws IOException {
        return new ArrayList<String>(this.collectDataByNodeName((Callable)new JmxValueTask(jmxValueParameter)).values());
    }

    Map<String, List<MBeanNode>> collectMBeanNodesByNodeName() throws IOException {
        return this.collectDataByNodeName((Callable)MBEANS_TASK);
    }

    Map<String, List<ProcessInformations>> collectProcessInformationsByNodeName() throws IOException {
        return this.collectDataByNodeName((Callable)PROCESS_INFORMATIONS_TASK);
    }

    HeapHistogram collectGlobalHeapHistogram() throws IOException {
        Map<String, HeapHistogram> heapHistograms = this.collectDataByNodeName((Callable)HEAP_HISTOGRAM_TASK);
        HeapHistogram heapHistoTotal = null;
        for (HeapHistogram heapHisto : heapHistograms.values()) {
            if (heapHistoTotal == null) {
                heapHistoTotal = heapHisto;
                continue;
            }
            if (heapHisto == null) continue;
            heapHistoTotal.add(heapHisto);
        }
        if (heapHistoTotal == null) {
            throw new IllegalStateException(I18N.getString((String)"heap_histo_non_supporte"));
        }
        return heapHistoTotal;
    }

    String forwardAction(String actionName, String sessionId, String threadId, String jobId, String cacheId) throws IOException {
        ActionTask task = new ActionTask(actionName, sessionId, threadId, jobId, cacheId);
        Map messagesByNodeName = this.collectDataByNodeName((Callable)task);
        StringBuilder sb = new StringBuilder();
        for (String messageForReport : messagesByNodeName.values()) {
            if (messageForReport == null) continue;
            sb.append(messageForReport).append('\n');
        }
        String messageForReport = sb.length() == 0 ? null : sb.toString();
        return messageForReport;
    }

    private static class DelegatingTask<T>
    extends MasterToSlaveCallable<T, Throwable> {
        private static final long serialVersionUID = -8596757920851396797L;
        private final Callable<T, Throwable> delegate;
        private final Locale locale;

        DelegatingTask(Callable<T, Throwable> delegate) {
            this.delegate = delegate;
            this.locale = I18N.getCurrentLocale();
        }

        public T call() throws Throwable {
            I18N.bindLocale((Locale)this.locale);
            try {
                Object object = this.delegate.call();
                return (T)object;
            }
            finally {
                I18N.unbindLocale();
            }
        }
    }

    private static class JmxValueTask
    extends MasterToSlaveCallable<String, Throwable> {
        private static final long serialVersionUID = -4654080667819214726L;
        private final String jmxValueParameter;

        JmxValueTask(String jmxValueParameter) {
            this.jmxValueParameter = jmxValueParameter;
        }

        public String call() throws Throwable {
            return MBeans.getConvertedAttributes((String)this.jmxValueParameter);
        }
    }

    private static final class ActionTask
    extends MasterToSlaveCallable<String, Throwable> {
        private static final long serialVersionUID = -3978979765596110525L;
        private final String actionName;
        private final String sessionId;
        private final String threadId;
        private final String jobId;
        private final String cacheId;

        ActionTask(String actionName, String sessionId, String threadId, String jobId, String cacheId) {
            this.actionName = actionName;
            this.sessionId = sessionId;
            this.threadId = threadId;
            this.jobId = jobId;
            this.cacheId = cacheId;
        }

        public String call() throws Throwable {
            Action action = Action.valueOfIgnoreCase((String)this.actionName);
            return action.execute(null, null, null, this.sessionId, this.threadId, this.jobId, this.cacheId);
        }
    }

    private static final class JavaInformationsTask
    extends MasterToSlaveCallable<JavaInformations, Throwable> {
        private static final long serialVersionUID = 4778731836785411552L;

        JavaInformationsTask() {
        }

        public JavaInformations call() throws Throwable {
            JavaInformations.setWebXmlExistsAndPomXmlExists((boolean)false, (boolean)true);
            return new JavaInformations(null, true);
        }
    }

    private static final class HeapHistogramTask
    extends MasterToSlaveCallable<HeapHistogram, Throwable> {
        private static final long serialVersionUID = -3978979765596110525L;

        HeapHistogramTask() {
        }

        public HeapHistogram call() throws Throwable {
            if (VirtualMachine.isSupported()) {
                return VirtualMachine.createHeapHistogram();
            }
            return null;
        }
    }

    private static final class ProcessInformationsTask
    extends MasterToSlaveCallable<List<ProcessInformations>, Throwable> {
        private static final long serialVersionUID = -4653173833541398792L;

        ProcessInformationsTask() {
        }

        public List<ProcessInformations> call() throws Throwable {
            return ProcessInformations.buildProcessInformations();
        }
    }

    private static final class MBeansTask
    extends MasterToSlaveCallable<List<MBeanNode>, Throwable> {
        private static final long serialVersionUID = 7010512609895185019L;

        MBeansTask() {
        }

        public List<MBeanNode> call() throws Throwable {
            return MBeans.getAllMBeanNodes();
        }
    }
}

