/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Extension;
import hudson.XmlFile;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.RootAction;
import hudson.plugins.jobConfigHistory.ConfigInfo;
import hudson.plugins.jobConfigHistory.ConfigInfoComparator;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.JobConfigHistoryBaseAction;
import hudson.plugins.jobConfigHistory.JobConfigHistoryProjectAction;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class JobConfigHistoryRootAction
extends JobConfigHistoryBaseAction
implements RootAction {
    private static final Logger LOG = Logger.getLogger(JobConfigHistoryRootAction.class.getName());

    @Override
    public final String getUrlName() {
        return "/jobConfigHistory";
    }

    public final List<ConfigInfo> getConfigs() throws IOException {
        String filter = this.getRequestParameter("filter");
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        if (filter == null) {
            List projects = Hudson.getInstance().getItems(AbstractProject.class);
            for (AbstractProject project : projects) {
                LOG.finest("getConfigs: Getting configs for " + project.getName());
                JobConfigHistoryProjectAction action = new JobConfigHistoryProjectAction(project);
                List<ConfigInfo> jobConfigs = action.getConfigs();
                LOG.finest("getConfigs: " + project.getName() + " has " + jobConfigs.size() + " history items");
                configs.addAll(jobConfigs);
            }
        }
        List<ConfigInfo> systemConfigs = this.getSystemConfigs(filter);
        LOG.finest("getSystemConfigs: has " + systemConfigs.size() + " history items");
        configs.addAll(systemConfigs);
        Collections.sort(configs, ConfigInfoComparator.INSTANCE);
        return configs;
    }

    protected List<ConfigInfo> getSystemConfigs(String filter) throws IOException {
        this.checkConfigurePermission();
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        File systemHistoryRootDir = this.getPlugin().getSystemHistoryDir();
        if (!systemHistoryRootDir.isDirectory()) {
            LOG.fine(systemHistoryRootDir + " is not a directory, assuming that no history exists yet.");
        } else {
            for (File systemConfigEntry : systemHistoryRootDir.listFiles()) {
                if (filter != null && !filter.equals(systemConfigEntry.getName())) continue;
                for (File historyDir : systemConfigEntry.listFiles(JobConfigHistory.HISTORY_FILTER)) {
                    XmlFile historyXml = new XmlFile(new File(historyDir, "history.xml"));
                    HistoryDescr histDescr = (HistoryDescr)historyXml.read();
                    ConfigInfo config = ConfigInfo.create(systemConfigEntry.getName(), historyDir, histDescr);
                    configs.add(config);
                }
            }
        }
        return configs;
    }

    public boolean isFiltered() {
        return this.getRequestParameter("filter") != null;
    }

    public String getFilter() {
        return this.getRequestParameter("filter");
    }

    @Override
    protected AccessControlled getAccessControlledObject() {
        return this.getHudson();
    }

    @Override
    protected void checkConfigurePermission() {
        this.getAccessControlledObject().checkPermission(Permission.CONFIGURE);
    }

    @Override
    protected boolean hasConfigurePermission() {
        return this.getAccessControlledObject().hasPermission(Permission.CONFIGURE);
    }
}

