/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.japex;

import com.sun.japex.report.TestSuiteReport;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.Project;
import hudson.plugins.japex.HudsonChartGenerator;
import hudson.plugins.japex.JapexPublisher;
import hudson.plugins.japex.TrendReport;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapexReportAction
implements Action,
StaplerProxy {
    private final Project<?, ?> project;
    private WeakReference<Parsed> cache;
    private static final FileFilter REPORT_FILTER = new FileFilter(){

        public boolean accept(File f) {
            return f.getName().endsWith(".xml");
        }
    };
    private static final Logger LOGGER = Logger.getLogger(JapexReportAction.class.getName());

    public JapexReportAction(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public String getDisplayName() {
        return "Japex Trend Report";
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "japex";
    }

    public TrendReport getReport(String configName) throws IOException {
        return this.parseReports().reports.get(configName);
    }

    public TrendReport getDynamic(String token, StaplerRequest req, StaplerResponse rsp) throws IOException {
        return this.getReport(token);
    }

    public boolean hasReports() throws IOException {
        return !this.parseReports().reports.isEmpty();
    }

    public Collection<TrendReport> getReports() throws IOException {
        return this.parseReports().reports.values();
    }

    public Object getTarget() {
        try {
            Parsed parsed = this.parseReports();
            if (parsed.singleton != null) {
                return parsed.singleton;
            }
            return this;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to parse Japex reports", e);
            return this;
        }
    }

    synchronized Parsed parseReports() throws IOException {
        Parsed parsed;
        Build lb = (Build)this.project.getLastBuild();
        if (this.cache != null && (parsed = (Parsed)this.cache.get()) != null && lb != null && parsed.buildNumber == lb.getNumber()) {
            return parsed;
        }
        HashMap<String, List<TestSuiteReport>> reports = new HashMap<String, List<TestSuiteReport>>();
        for (Build build : this.project.getBuilds()) {
            File dir = JapexPublisher.getJapexReport(build);
            File[] files = dir.listFiles(REPORT_FILTER);
            if (files == null) continue;
            for (File f : files) {
                IOException x;
                try {
                    TestSuiteReport rpt = new TestSuiteReport(f);
                    String configName = ((String)rpt.getParameters().get("configFile")).replace('/', '.');
                    ArrayList<TestSuiteReport> reportList = (ArrayList<TestSuiteReport>)reports.get(configName);
                    if (reportList == null) {
                        reportList = new ArrayList<TestSuiteReport>();
                        reports.put(configName, reportList);
                    }
                    reportList.add(rpt);
                }
                catch (SAXException e) {
                    x = new IOException("Failed to parse " + f);
                    x.initCause(e);
                    throw x;
                }
                catch (RuntimeException e) {
                    x = new IOException("Failed to parse " + f);
                    x.initCause(e);
                    throw x;
                }
            }
        }
        Parsed parsed2 = new Parsed(lb, reports);
        this.cache = new WeakReference<Parsed>(parsed2);
        return parsed2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Parsed {
        final Map<String, TrendReport> reports = new HashMap<String, TrendReport>();
        final int buildNumber;
        final TrendReport singleton;

        public Parsed(Build build, Map<String, List<TestSuiteReport>> reports) {
            this.buildNumber = build.getNumber();
            for (Map.Entry<String, List<TestSuiteReport>> e : reports.entrySet()) {
                this.reports.put(e.getKey(), new TrendReport(JapexReportAction.this.project, e.getKey(), new HudsonChartGenerator(e.getValue(), build)));
            }
            this.singleton = reports.size() == 1 ? this.reports.values().iterator().next() : null;
        }
    }
}

