/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.hipchat.workflow;

import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.plugins.hipchat.CardProvider;
import jenkins.plugins.hipchat.HipChatNotifier;
import jenkins.plugins.hipchat.HipChatService;
import jenkins.plugins.hipchat.Messages;
import jenkins.plugins.hipchat.exceptions.NotificationException;
import jenkins.plugins.hipchat.impl.NoopCardProvider;
import jenkins.plugins.hipchat.model.notifications.Icon;
import jenkins.plugins.hipchat.model.notifications.Notification;
import jenkins.plugins.hipchat.utils.BuildUtils;
import jenkins.plugins.hipchat.utils.CredentialUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class HipChatSendStep
extends AbstractStepImpl {
    private static final Logger logger = Logger.getLogger(HipChatSendStep.class.getName());
    public final String message;
    @DataBoundSetter
    public Notification.Color color;
    @DataBoundSetter
    public String icon;
    @Deprecated
    @DataBoundSetter
    public String token;
    @DataBoundSetter
    public String credentialId;
    @DataBoundSetter
    public String room;
    @DataBoundSetter
    public String server;
    @DataBoundSetter
    public boolean notify;
    @DataBoundSetter
    public boolean textFormat;
    @DataBoundSetter
    public Boolean v2enabled;
    @DataBoundSetter
    public String sendAs;
    @DataBoundSetter
    public boolean failOnError;

    @DataBoundConstructor
    public HipChatSendStep(@Nonnull String message) {
        this.message = message;
    }

    public static class HipChatSendStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient BuildUtils buildUtils;
        @Inject
        private transient CredentialUtils credentialUtils;
        @Inject
        private transient HipChatSendStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Run<?, ?> run;

        protected Void run() throws Exception {
            StringCredentials creds;
            if (StringUtils.isBlank((String)this.step.message)) {
                if (this.step.failOnError) {
                    throw new AbortException(Messages.MessageRequiredError());
                }
                this.listener.error(Messages.MessageRequiredError());
                return null;
            }
            HipChatNotifier.DescriptorImpl hipChatDesc = (HipChatNotifier.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(HipChatNotifier.DescriptorImpl.class);
            String room = this.firstNonEmpty(this.step.room, hipChatDesc.getRoom());
            String server = this.firstNonEmpty(this.step.server, hipChatDesc.getServer());
            String sendAs = this.firstNonEmpty(this.step.sendAs, hipChatDesc.getSendAs());
            String credentialId = this.step.credentialId;
            String token = null;
            if (StringUtils.isEmpty((String)credentialId)) {
                if (StringUtils.isEmpty((String)this.step.token)) {
                    credentialId = hipChatDesc.getCredentialId();
                } else {
                    token = this.step.token;
                }
            }
            if (StringUtils.isNotEmpty((String)credentialId) && (creds = this.credentialUtils.resolveCredential((Item)this.run.getParent(), credentialId, server)) != null) {
                token = Secret.toString((Secret)creds.getSecret());
            }
            Notification.Color color = this.step.color != null ? this.step.color : Notification.Color.GRAY;
            boolean v2enabled = this.step.v2enabled != null ? this.step.v2enabled.booleanValue() : hipChatDesc.isV2Enabled();
            HipChatService hipChatService = HipChatNotifier.getHipChatService(server, token, v2enabled, room, sendAs);
            logger.log(Level.FINER, "HipChat publish settings: api v2 - {0} server - {1} token - {2} room - {3}", new Object[]{v2enabled, server, token, room});
            try {
                FilePath workspace = null;
                try {
                    workspace = (FilePath)this.getContext().get(FilePath.class);
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
                String message = TokenMacro.expandAll(this.run, (FilePath)workspace, (TaskListener)this.listener, (String)HipChatNotifier.migrateMessageTemplate(this.step.message), (boolean)false, null);
                CardProvider cardProvider = (CardProvider)((Object)ExtensionList.lookup(CardProvider.class).getDynamic(((HipChatNotifier.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(HipChatNotifier.DescriptorImpl.class)).getCardProvider()));
                if (cardProvider == null) {
                    cardProvider = new NoopCardProvider();
                }
                hipChatService.publish(new Notification().withColor(color).withMessage(message).withCard(cardProvider.getCard(this.run, this.listener, StringUtils.isEmpty((String)this.step.icon) ? null : new Icon().withUrl(this.step.icon), message)).withNotify(this.step.notify).withMessageFormat(this.step.textFormat ? Notification.MessageFormat.TEXT : Notification.MessageFormat.HTML));
                this.listener.getLogger().println(Messages.NotificationSuccessful(room));
            }
            catch (IOException | NotificationException | MacroEvaluationException ex) {
                this.listener.getLogger().println(Messages.NotificationFailed(ex.getMessage()));
                if (this.step.failOnError) {
                    throw new AbortException(Messages.NotificationFailed(ex.getMessage()));
                }
                this.listener.error(Messages.NotificationFailed(ex.getMessage()));
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            return null;
        }

        private String firstNonEmpty(String value, String defaultValue) {
            return StringUtils.isNotEmpty((String)value) ? value : defaultValue;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(HipChatSendStepExecution.class);
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item context, @QueryParameter String server) {
            return ((HipChatNotifier.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(HipChatNotifier.DescriptorImpl.class)).doFillCredentialIdItems(context, server);
        }

        public String getFunctionName() {
            return "hipchatSend";
        }

        public String getDisplayName() {
            return Messages.HipChatSendStepDisplayName();
        }
    }
}

