/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.hipchat.model.notifications;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.plugins.hipchat.model.notifications.Activity;
import jenkins.plugins.hipchat.model.notifications.Attribute;
import jenkins.plugins.hipchat.model.notifications.Thumbnail;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"style", "description", "format", "url", "title", "thumbnail", "activity", "attributes", "id", "icon"})
public class Card {
    @JsonProperty(value="style")
    private Style style;
    @JsonProperty(value="description")
    private Object description;
    @JsonProperty(value="format")
    private Format format;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="thumbnail")
    private Thumbnail thumbnail;
    @JsonProperty(value="activity")
    private Activity activity;
    @JsonProperty(value="attributes")
    private List<Attribute> attributes = null;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="icon")
    private Object icon;

    @JsonProperty(value="style")
    public Style getStyle() {
        return this.style;
    }

    @JsonProperty(value="style")
    public void setStyle(Style style) {
        this.style = style;
    }

    public Card withStyle(Style style) {
        this.style = style;
        return this;
    }

    @JsonProperty(value="description")
    public Object getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(Object description) {
        this.description = description;
    }

    public Card withDescription(Object description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="format")
    public Format getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    public void setFormat(Format format) {
        this.format = format;
    }

    public Card withFormat(Format format) {
        this.format = format;
        return this;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    public Card withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public Card withTitle(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty(value="thumbnail")
    public Thumbnail getThumbnail() {
        return this.thumbnail;
    }

    @JsonProperty(value="thumbnail")
    public void setThumbnail(Thumbnail thumbnail) {
        this.thumbnail = thumbnail;
    }

    public Card withThumbnail(Thumbnail thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    @JsonProperty(value="activity")
    public Activity getActivity() {
        return this.activity;
    }

    @JsonProperty(value="activity")
    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public Card withActivity(Activity activity) {
        this.activity = activity;
        return this;
    }

    @JsonProperty(value="attributes")
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public Card withAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public Card withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="icon")
    public Object getIcon() {
        return this.icon;
    }

    @JsonProperty(value="icon")
    public void setIcon(Object icon) {
        this.icon = icon;
    }

    public Card withIcon(Object icon) {
        this.icon = icon;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.style).append(this.description).append((Object)this.format).append((Object)this.url).append((Object)this.title).append((Object)this.thumbnail).append((Object)this.activity).append(this.attributes).append((Object)this.id).append(this.icon).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Card)) {
            return false;
        }
        Card rhs = (Card)other;
        return new EqualsBuilder().append((Object)this.style, (Object)rhs.style).append(this.description, rhs.description).append((Object)this.format, (Object)rhs.format).append((Object)this.url, (Object)rhs.url).append((Object)this.title, (Object)rhs.title).append((Object)this.thumbnail, (Object)rhs.thumbnail).append((Object)this.activity, (Object)rhs.activity).append(this.attributes, rhs.attributes).append((Object)this.id, (Object)rhs.id).append(this.icon, rhs.icon).isEquals();
    }

    public static enum Style {
        FILE("file"),
        IMAGE("image"),
        APPLICATION("application"),
        LINK("link"),
        MEDIA("media");

        private final String value;
        private static final Map<String, Style> CONSTANTS;

        private Style(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Style fromValue(String value) {
            Style constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Style>();
            for (Style c : Style.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Format {
        COMPACT("compact"),
        MEDIUM("medium");

        private final String value;
        private static final Map<String, Format> CONSTANTS;

        private Format(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Format fromValue(String value) {
            Format constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Format>();
            for (Format c : Format.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

