/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.hipchat.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.hipchat.HipChatService;
import jenkins.plugins.hipchat.Messages;
import jenkins.plugins.hipchat.exceptions.InvalidResponseCodeException;
import jenkins.plugins.hipchat.exceptions.NotificationException;
import jenkins.plugins.hipchat.model.notifications.Notification;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class HipChatV1Service
extends HipChatService {
    private static final Logger logger = Logger.getLogger(HipChatV1Service.class.getName());
    private static final String[] DEFAULT_ROOMS = new String[0];
    private final String server;
    private final String token;
    private final String[] roomIds;
    private final String sendAs;

    public HipChatV1Service(String server, String token, String roomIds, String sendAs) {
        this.server = server;
        this.token = token;
        this.roomIds = roomIds == null ? DEFAULT_ROOMS : roomIds.split("\\s*,\\s*");
        this.sendAs = sendAs;
    }

    @Override
    public void publish(Notification notification) throws NotificationException {
        for (String roomId : this.roomIds) {
            logger.log(Level.FINE, "Posting: {0} to {1}: {2}", new Object[]{this.sendAs, roomId, notification});
            CloseableHttpClient httpClient = this.getHttpClient();
            CloseableHttpResponse httpResponse = null;
            try {
                HttpPost post = new HttpPost("https://" + this.server + "/v1/rooms/message");
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>(6);
                nvps.add(new BasicNameValuePair("auth_token", this.token));
                nvps.add(new BasicNameValuePair("from", this.sendAs));
                nvps.add(new BasicNameValuePair("room_id", roomId));
                nvps.add(new BasicNameValuePair("message", notification.getMessage()));
                nvps.add(new BasicNameValuePair("message_format", notification.getMessageFormat().value()));
                nvps.add(new BasicNameValuePair("color", notification.getColor().value()));
                nvps.add(new BasicNameValuePair("notify", notification.isNotify() ? "1" : "0"));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
                httpResponse = httpClient.execute((HttpUriRequest)post);
                int responseCode = httpResponse.getStatusLine().getStatusCode();
                String response = this.readResponse(httpResponse.getEntity());
                if (responseCode != 200) {
                    logger.log(Level.WARNING, "HipChat post may have failed. ResponseCode: {0}, Response: {1}", new Object[]{responseCode, response});
                    throw new InvalidResponseCodeException(responseCode);
                }
            }
            catch (IOException ioe) {
                try {
                    logger.log(Level.WARNING, "An IO error occurred while posting HipChat notification", ioe);
                    throw new NotificationException(Messages.IOException(ioe.toString()));
                }
                catch (Throwable throwable) {
                    this.closeQuietly(new Closeable[]{httpResponse, httpClient});
                    throw throwable;
                }
            }
            this.closeQuietly(new Closeable[]{httpResponse, httpClient});
        }
    }
}

