/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.hipchat.ext.tokens;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogSet;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.hipchat.utils.TokenMacroUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;

@Extension
public class CommitMessageMacro
extends DataBoundTokenMacro {
    private static final Logger LOGGER = Logger.getLogger(CommitMessageMacro.class.getName());
    @DataBoundTokenMacro.Parameter
    public boolean escape = true;

    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) {
        if (context.hasChangeSetComputed()) {
            return this.getCommitMessage((ChangeLogSet<? extends ChangeLogSet.Entry>)context.getChangeSet());
        }
        LOGGER.log(Level.FINE, "No changeset computed for job {0}", context.getProject().getFullDisplayName());
        return "";
    }

    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) {
        if (run instanceof AbstractBuild) {
            return this.evaluate((AbstractBuild)run, listener, macroName);
        }
        return this.getCommitMessage(TokenMacroUtils.getFirstChangeSet(run));
    }

    public boolean acceptsMacroName(String macroName) {
        return "COMMIT_MESSAGE".equals(macroName);
    }

    public List<String> getAcceptedMacroNames() {
        return Collections.singletonList("COMMIT_MESSAGE");
    }

    private String getCommitMessage(ChangeLogSet<? extends ChangeLogSet.Entry> changeSet) {
        Object[] items;
        if (changeSet != null && (items = changeSet.getItems()) != null && items.length > 0) {
            ChangeLogSet.Entry entry = (ChangeLogSet.Entry)items[items.length - 1];
            LOGGER.log(Level.FINEST, "Entry {0}", entry);
            return this.stripMessage(this.escape ? entry.getMsgEscaped() : entry.getMsg());
        }
        return "";
    }

    private String stripMessage(String message) {
        return Util.fixNull((String)message).split("\r?\n")[0];
    }
}

