/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.hipchat.ext.tokens;

import com.google.common.collect.ListMultimap;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

@Extension
public class BuildDurationMacro
extends TokenMacro {
    public boolean acceptsMacroName(String macroName) {
        return "BUILD_DURATION".equals(macroName);
    }

    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName, Map<String, String> arguments, ListMultimap<String, String> argumentMultimap) {
        return this.evaluate((Run<?, ?>)context, null, listener, macroName, arguments, argumentMultimap);
    }

    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName, Map<String, String> arguments, ListMultimap<String, String> argumentMultimap) {
        long duration = run.getDuration();
        if (duration == 0L) {
            return Util.getTimeSpanString((long)(System.currentTimeMillis() - run.getStartTimeInMillis()));
        }
        return Util.getTimeSpanString((long)duration);
    }

    public List<String> getAcceptedMacroNames() {
        return Collections.singletonList("BUILD_DURATION");
    }
}

