/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.hipchat;

import com.google.common.collect.ImmutableMap;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.hipchat.CardProvider;
import jenkins.plugins.hipchat.HipChatService;
import jenkins.plugins.hipchat.Messages;
import jenkins.plugins.hipchat.exceptions.NotificationException;
import jenkins.plugins.hipchat.impl.DefaultCardProvider;
import jenkins.plugins.hipchat.impl.HipChatV1Service;
import jenkins.plugins.hipchat.impl.HipChatV2Service;
import jenkins.plugins.hipchat.model.MatrixTriggerMode;
import jenkins.plugins.hipchat.model.NotificationConfig;
import jenkins.plugins.hipchat.model.NotificationType;
import jenkins.plugins.hipchat.model.notifications.Notification;
import jenkins.plugins.hipchat.utils.BuildUtils;
import jenkins.plugins.hipchat.utils.CredentialUtils;
import jenkins.plugins.hipchat.utils.GuiceUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class HipChatNotifier
extends Notifier
implements MatrixAggregatable {
    private static final Logger logger = Logger.getLogger(HipChatNotifier.class.getName());
    private static final ImmutableMap<String, String> MESSAGE_MIRATION_MAPPING = ImmutableMap.builder().put((Object)"DURATION", (Object)"${BUILD_DURATION}").put((Object)"JOB_DISPLAY_NAME", (Object)"${PROJECT_DISPLAY_NAME}").put((Object)"TEST_COUNT", (Object)"${TEST_COUNTS,var=\"total\"}").put((Object)"FAILED_TEST_COUNT", (Object)"${TEST_COUNTS,var=\"fail\"}").put((Object)"SKIPPED_TEST_COUNT", (Object)"${TEST_COUNTS,var=\"skip\"}").put((Object)"SUCCESS_TEST_COUNT", (Object)"${TEST_COUNTS,var=\"pass\"}").put((Object)"URL", (Object)"${BUILD_URL}").put((Object)"COMMIT_MESSAGE", (Object)"${COMMIT_MESSAGE}").put((Object)"COMMIT_MESSAGE_TEXT", (Object)"${COMMIT_MESSAGE,escape=false}").put((Object)"CHANGES", (Object)"${HIPCHAT_CHANGES}").put((Object)"CHANGES_OR_CAUSE", (Object)"${HIPCHAT_CHANGES_OR_CAUSE}").build();
    @Deprecated
    private transient String token;
    @Deprecated
    private transient boolean startNotification;
    @Deprecated
    private transient boolean notifySuccess;
    @Deprecated
    private transient boolean notifyAborted;
    @Deprecated
    private transient boolean notifyNotBuilt;
    @Deprecated
    private transient boolean notifyUnstable;
    @Deprecated
    private transient boolean notifyFailure;
    @Deprecated
    private transient boolean notifyBackToNormal;
    private String credentialId;
    private String room;
    private List<NotificationConfig> notifications;
    private MatrixTriggerMode matrixTriggerMode;
    private String startJobMessage;
    private String completeJobMessage;

    @DataBoundConstructor
    public HipChatNotifier(String credentialId, String room, List<NotificationConfig> notifications, MatrixTriggerMode matrixTriggerMode, String startJobMessage, String completeJobMessage) {
        this.credentialId = credentialId;
        this.room = room;
        this.notifications = notifications;
        this.matrixTriggerMode = matrixTriggerMode;
        this.startJobMessage = startJobMessage;
        this.completeJobMessage = completeJobMessage;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    public void setStartNotification(boolean startNotification) {
        this.startNotification = startNotification;
    }

    public void setNotifySuccess(boolean notifySuccess) {
        this.notifySuccess = notifySuccess;
    }

    public void setNotifyAborted(boolean notifyAborted) {
        this.notifyAborted = notifyAborted;
    }

    public void setNotifyNotBuilt(boolean notifyNotBuilt) {
        this.notifyNotBuilt = notifyNotBuilt;
    }

    public void setNotifyUnstable(boolean notifyUnstable) {
        this.notifyUnstable = notifyUnstable;
    }

    public void setNotifyFailure(boolean notifyFailure) {
        this.notifyFailure = notifyFailure;
    }

    public void setNotifyBackToNormal(boolean notifyBackToNormal) {
        this.notifyBackToNormal = notifyBackToNormal;
    }

    public MatrixTriggerMode getMatrixTriggerMode() {
        return this.matrixTriggerMode == null ? MatrixTriggerMode.BOTH : this.matrixTriggerMode;
    }

    public void setMatrixTriggerMode(MatrixTriggerMode matrixTriggerMode) {
        this.matrixTriggerMode = matrixTriggerMode;
    }

    public void setNotifications(List<NotificationConfig> notifications) {
        this.notifications = notifications;
    }

    public List<NotificationConfig> getNotifications() {
        return this.notifications;
    }

    public String getStartJobMessage() {
        return this.startJobMessage;
    }

    public void setStartJobMessage(String startJobMessage) {
        this.startJobMessage = startJobMessage;
    }

    public String getCompleteJobMessage() {
        return this.completeJobMessage;
    }

    public void setCompleteJobMessage(String completeJobMessage) {
        this.completeJobMessage = completeJobMessage;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public Object readResolve() {
        if (this.notifications == null) {
            this.notifications = new ArrayList<NotificationConfig>(7);
            if (this.startNotification) {
                this.notifications.add(new NotificationConfig(false, false, NotificationType.STARTED, Notification.Color.GREEN, null, null));
            }
            if (this.notifySuccess) {
                this.notifications.add(new NotificationConfig(false, false, NotificationType.SUCCESS, Notification.Color.GREEN, null, null));
            }
            if (this.notifyAborted) {
                this.notifications.add(new NotificationConfig(true, false, NotificationType.ABORTED, Notification.Color.GRAY, null, null));
            }
            if (this.notifyNotBuilt) {
                this.notifications.add(new NotificationConfig(true, false, NotificationType.NOT_BUILT, Notification.Color.GRAY, null, null));
            }
            if (this.notifyUnstable) {
                this.notifications.add(new NotificationConfig(true, false, NotificationType.UNSTABLE, Notification.Color.YELLOW, null, null));
            }
            if (this.notifyFailure) {
                this.notifications.add(new NotificationConfig(true, false, NotificationType.FAILURE, Notification.Color.RED, null, null));
            }
            if (this.notifyBackToNormal) {
                this.notifications.add(new NotificationConfig(false, false, NotificationType.BACK_TO_NORMAL, Notification.Color.GREEN, null, null));
            }
        }
        return this;
    }

    public String getResolvedRoom(AbstractBuild<?, ?> build) {
        return Util.replaceMacro((String)(StringUtils.isBlank((String)this.room) ? this.getDescriptor().getRoom() : this.room), (VariableResolver)build.getBuildVariableResolver());
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        logger.fine("Creating build start notification");
        if (!(build instanceof MatrixRun) || this.getMatrixTriggerMode().forChild) {
            this.publishNotificationIfEnabled(NotificationType.STARTED, build, listener);
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (!(build instanceof MatrixRun) || this.getMatrixTriggerMode().forChild) {
            this.notifyOnBuildComplete(build, listener);
        }
        return true;
    }

    private void notifyOnBuildComplete(AbstractBuild<?, ?> build, BuildListener listener) {
        logger.fine("Creating build completed notification");
        Result result = build.getResult();
        Result previousResult = GuiceUtils.get(BuildUtils.class).findPreviousBuildResult((Run<?, ?>)build);
        NotificationType notificationType = NotificationType.fromResults(previousResult, result);
        this.publishNotificationIfEnabled(notificationType, build, listener);
    }

    private void publishNotificationIfEnabled(NotificationType notificationType, AbstractBuild<?, ?> build, BuildListener listener) {
        logger.log(Level.FINE, "Checking if notification {0} is enabled", (Object)notificationType);
        NotificationConfig notificationConfig = this.getNotificationConfig(notificationType);
        if (notificationConfig != null) {
            logger.log(Level.FINE, "Notification config found for notification type {0}: {1}", new Object[]{notificationType, notificationConfig.toString()});
            String messageTemplate = Util.fixEmpty((String)notificationConfig.getMessageTemplate());
            if (messageTemplate == null) {
                messageTemplate = notificationType.isStartType() ? (Util.fixEmpty((String)this.getStartJobMessage()) == null ? this.getDescriptor().getStartJobMessageDefault() : this.getStartJobMessage()) : (Util.fixEmpty((String)this.getCompleteJobMessage()) == null ? this.getDescriptor().getCompleteJobMessageDefault() : this.getCompleteJobMessage());
            }
            notificationConfig = notificationConfig.overrideMessageTemplate(HipChatNotifier.migrateMessageTemplate(messageTemplate));
            try {
                this.getHipChatService(build).publish(notificationType.getNotification(notificationConfig, build, listener));
                listener.getLogger().println(Messages.NotificationSuccessful(this.getResolvedRoom(build)));
            }
            catch (NotificationException ne) {
                listener.getLogger().println(Messages.NotificationFailed(ne.getMessage()));
            }
        }
    }

    public static String migrateMessageTemplate(String oldMessageTemplate) {
        return Util.replaceMacro((String)oldMessageTemplate, MESSAGE_MIRATION_MAPPING);
    }

    private NotificationConfig getNotificationConfig(NotificationType notificationType) {
        List configs = Util.fixNull(this.notifications).isEmpty() ? Util.fixNull(this.getDescriptor().getDefaultNotifications()) : this.notifications;
        for (NotificationConfig notificationConfig : configs) {
            if (!notificationType.equals((Object)notificationConfig.getNotificationType())) continue;
            return notificationConfig;
        }
        return null;
    }

    private HipChatService getHipChatService(AbstractBuild<?, ?> build) throws NotificationException {
        DescriptorImpl desc = this.getDescriptor();
        StringCredentials credentials = GuiceUtils.get(CredentialUtils.class).resolveCredential((Item)build.getParent(), Util.fixEmpty((String)this.credentialId) != null ? this.credentialId : desc.getCredentialId(), desc.getServer());
        if (credentials == null) {
            throw new NotificationException(Messages.CredentialMissing(this.credentialId));
        }
        return HipChatNotifier.getHipChatService(desc.getServer(), Secret.toString((Secret)credentials.getSecret()), desc.isV2Enabled(), this.getResolvedRoom(build), desc.getSendAs());
    }

    public static HipChatService getHipChatService(String server, String token, boolean v2Enabled, String room, String sendAs) {
        if (v2Enabled) {
            return new HipChatV2Service(server, token, room);
        }
        return new HipChatV1Service(server, token, room, sendAs);
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(build, launcher, listener){

            public boolean startBuild() throws InterruptedException, IOException {
                if (HipChatNotifier.this.getMatrixTriggerMode().forParent) {
                    HipChatNotifier.this.publishNotificationIfEnabled(NotificationType.STARTED, (AbstractBuild)this.build, this.listener);
                }
                return true;
            }

            public boolean endBuild() throws InterruptedException, IOException {
                if (HipChatNotifier.this.getMatrixTriggerMode().forParent) {
                    HipChatNotifier.this.notifyOnBuildComplete((AbstractBuild)this.build, this.listener);
                }
                return true;
            }
        };
    }

    @Deprecated
    public static class HipChatJobProperty
    extends JobProperty<AbstractProject<?, ?>> {
        private final String room;
        private final boolean startNotification;
        private final boolean notifySuccess;
        private final boolean notifyAborted;
        private final boolean notifyNotBuilt;
        private final boolean notifyUnstable;
        private final boolean notifyFailure;
        private final boolean notifyBackToNormal;

        @DataBoundConstructor
        public HipChatJobProperty(String room, boolean startNotification, boolean notifyAborted, boolean notifyFailure, boolean notifyNotBuilt, boolean notifySuccess, boolean notifyUnstable, boolean notifyBackToNormal) {
            this.room = room;
            this.startNotification = startNotification;
            this.notifyAborted = notifyAborted;
            this.notifyFailure = notifyFailure;
            this.notifyNotBuilt = notifyNotBuilt;
            this.notifySuccess = notifySuccess;
            this.notifyUnstable = notifyUnstable;
            this.notifyBackToNormal = notifyBackToNormal;
        }

        @Exported
        public String getRoom() {
            return this.room;
        }

        @Exported
        public boolean getStartNotification() {
            return this.startNotification;
        }

        @Exported
        public boolean getNotifySuccess() {
            return this.notifySuccess;
        }

        @Exported
        public boolean getNotifyAborted() {
            return this.notifyAborted;
        }

        @Exported
        public boolean getNotifyFailure() {
            return this.notifyFailure;
        }

        @Exported
        public boolean getNotifyNotBuilt() {
            return this.notifyNotBuilt;
        }

        @Exported
        public boolean getNotifyUnstable() {
            return this.notifyUnstable;
        }

        @Exported
        public boolean getNotifyBackToNormal() {
            return this.notifyBackToNormal;
        }

        @Extension
        public static final class DescriptorImpl
        extends JobPropertyDescriptor {
            public String getDisplayName() {
                return "HipChat Notifications";
            }

            public boolean isApplicable(Class<? extends Job> jobType) {
                return true;
            }

            public HipChatJobProperty newInstance(StaplerRequest sr, JSONObject formData) throws Descriptor.FormException {
                if (sr == null) {
                    throw new IllegalArgumentException("staplerRequest must not be null");
                }
                return new HipChatJobProperty(sr.getParameter("hipChatProjectRoom"), sr.getParameter("hipChatStartNotification") != null, sr.getParameter("hipChatNotifyAborted") != null, sr.getParameter("hipChatNotifyFailure") != null, sr.getParameter("hipChatNotifyNotBuilt") != null, sr.getParameter("hipChatNotifySuccess") != null, sr.getParameter("hipChatNotifyUnstable") != null, sr.getParameter("hipChatNotifyBackToNormal") != null);
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @Deprecated
        private transient String token;
        private String server = "api.hipchat.com";
        private String credentialId;
        private boolean v2Enabled = false;
        private String room;
        private String sendAs = "Jenkins";
        private String cardProvider = DefaultCardProvider.class.getName();
        private List<NotificationConfig> defaultNotifications;
        private String configVersion;
        private static int testNotificationCount = 0;

        public DescriptorImpl() {
            this.load();
            if (Util.fixEmpty((String)this.token) != null) {
                try {
                    GuiceUtils.get(CredentialUtils.class).migrateGlobalCredential(this);
                }
                catch (IOException ioe) {
                    logger.log(Level.SEVERE, "Unable to migrate globally stored auth token to a credential", ioe);
                }
            }
            if (Util.fixEmpty((String)this.configVersion) == null) {
                this.configVersion = "1.0.0";
            }
        }

        public String getServer() {
            return this.server;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public String getCredentialId() {
            return this.credentialId;
        }

        public void setCredentialId(String credentialId) {
            this.credentialId = credentialId;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public boolean isV2Enabled() {
            return this.v2Enabled;
        }

        public void setV2Enabled(boolean v2Enabled) {
            this.v2Enabled = v2Enabled;
        }

        public String getRoom() {
            return this.room;
        }

        public void setRoom(String room) {
            this.room = room;
        }

        public String getSendAs() {
            return this.sendAs;
        }

        public void setSendAs(String sendAs) {
            this.sendAs = sendAs;
        }

        public String getCardProvider() {
            return this.cardProvider;
        }

        public void setCardProvider(String cardProvider) {
            this.cardProvider = cardProvider;
        }

        public List<NotificationConfig> getDefaultNotifications() {
            return this.defaultNotifications;
        }

        public void setDefaultNotifications(List<NotificationConfig> defaultNotifications) {
            this.defaultNotifications = defaultNotifications;
        }

        public String getConfigVersion() {
            return this.configVersion;
        }

        public void setConfigVersion(String configVersion) {
            this.configVersion = configVersion;
        }

        public String getStartJobMessageDefault() {
            return Messages.JobStarted();
        }

        public String getCompleteJobMessageDefault() {
            return Messages.JobCompleted();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public boolean isMatrixProject(Object project) {
            return project instanceof MatrixProject;
        }

        public boolean configure(StaplerRequest request, JSONObject formData) throws Descriptor.FormException {
            request.bindJSON((Object)this, formData);
            this.save();
            return super.configure(request, formData);
        }

        public FormValidation doCheckSendAs(@QueryParameter boolean v2Enabled, @QueryParameter String sendAs) {
            sendAs = Util.fixEmpty((String)sendAs);
            if (!(v2Enabled || sendAs != null && sendAs.length() <= 15)) {
                return FormValidation.error((String)Messages.InvalidSendAs());
            }
            return FormValidation.ok();
        }

        public FormValidation doSendTestNotification(@AncestorInPath AbstractProject<?, ?> context, @QueryParameter String server, @QueryParameter String credentialId, @QueryParameter boolean v2Enabled, @QueryParameter String room, @QueryParameter String sendAs) {
            StringCredentials credentials = GuiceUtils.get(CredentialUtils.class).resolveCredential((Item)context, credentialId, server);
            if (credentials == null) {
                return FormValidation.error((String)Messages.CredentialMissing(credentialId));
            }
            HipChatService service = HipChatNotifier.getHipChatService(server, Secret.toString((Secret)credentials.getSecret()), v2Enabled, room, sendAs);
            try {
                service.publish(Messages.TestNotification(++testNotificationCount), "yellow", true);
                return FormValidation.ok((String)Messages.TestNotificationSent());
            }
            catch (NotificationException ne) {
                return FormValidation.error((String)Messages.TestNotificationFailed(ne.getMessage()));
            }
        }

        public ListBoxModel doFillCardProviderItems() {
            ExtensionList providers = ExtensionList.lookup(CardProvider.class);
            ArrayList<ListBoxModel.Option> clazzNames = new ArrayList<ListBoxModel.Option>(providers.size());
            for (CardProvider provider : providers) {
                clazzNames.add(new ListBoxModel.Option(provider.getDescriptor().getDisplayName(), ((Object)((Object)provider)).getClass().getName(), ((Object)((Object)provider)).getClass().getName().equals(this.cardProvider)));
            }
            return new ListBoxModel(clazzNames);
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item context, @QueryParameter String server) {
            return GuiceUtils.get(CredentialUtils.class).getAvailableCredentials(context, this.credentialId, Util.fixEmpty((String)server) == null ? this.server : server);
        }

        public String getDisplayName() {
            return Messages.DisplayName();
        }
    }
}

