/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.Plugin;
import hudson.plugins.analysis.core.PluginDescriptor;
import hudson.plugins.analysis.views.DetailFactory;
import hudson.plugins.findbugs.FindBugsDetailFactory;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.MavenInitialization;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecution;

public class FindBugsPlugin
extends Plugin {
    public void start() {
        this.initializeDetails();
    }

    private void initializeDetails() {
        FindBugsDetailFactory detailBuilder = new FindBugsDetailFactory();
        DetailFactory.addDetailBuilder(FindBugsResultAction.class, (DetailFactory)detailBuilder);
        if (PluginDescriptor.isMavenPluginInstalled()) {
            MavenInitialization.run(detailBuilder);
        }
    }

    public static boolean isFindBugs2x(MojoExecution mojoExecution) {
        try {
            String[] versions = StringUtils.split((String)mojoExecution.getVersion(), (String)".");
            if (versions.length > 1) {
                int major = Integer.parseInt(versions[0]);
                int minor = Integer.parseInt(versions[1]);
                return major > 2 || major == 2 && minor >= 4;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

