/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.parser;

import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.cloud.Cloud;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.util.TreeStringBuilder;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.LineRange;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.findbugs.FindBugsMessages;
import hudson.plugins.findbugs.parser.Bug;
import hudson.plugins.findbugs.parser.XmlBugInstance;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.digester3.Digester;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;
import org.jvnet.localizer.LocaleProvider;
import org.xml.sax.SAXException;

public class FindBugsParser
implements AnnotationParser {
    private static final long serialVersionUID = 8306319007761954027L;
    private static final String DOT = ".";
    private static final String SLASH = "/";
    private static final String CLOUD_DETAILS_URL_PROPERTY = "detailsUrl";
    private static final String EMPTY_STRING = "";
    private static final int DAY_IN_MSEC = 86400000;
    private static final int HIGH_PRIORITY_LOWEST_RANK = 4;
    private static final int NORMAL_PRIORITY_LOWEST_RANK = 9;
    @SuppressFBWarnings(value={"SE"})
    private final List<String> mavenSources = new ArrayList<String>();
    private final boolean isRankActivated;
    private final Set<Pattern> excludePatterns = Sets.newHashSet();
    private final Set<Pattern> includePatterns = Sets.newHashSet();
    private boolean isFirstError = true;

    public FindBugsParser(boolean isRankActivated) {
        this(isRankActivated, EMPTY_STRING, EMPTY_STRING);
    }

    public FindBugsParser(boolean isRankActivated, String excludePattern, String includePattern) {
        this(new ArrayList<String>(), isRankActivated, excludePattern, includePattern);
    }

    public FindBugsParser(Collection<String> sourceFolders, boolean isRankActivated, String excludePattern, String includePattern) {
        this.mavenSources.addAll(sourceFolders);
        this.isRankActivated = isRankActivated;
        this.addPatterns(this.includePatterns, includePattern);
        this.addPatterns(this.excludePatterns, excludePattern);
    }

    private void addPatterns(Set<Pattern> patterns, String pattern) {
        if (StringUtils.isNotBlank((String)pattern)) {
            String[] split;
            for (String singlePattern : split = StringUtils.split((String)pattern, (char)',')) {
                String trimmed = StringUtils.trim((String)singlePattern);
                String directoriesReplaced = StringUtils.replace((String)trimmed, (String)"**", (String)"*");
                patterns.add(Pattern.compile(StringUtils.replace((String)directoriesReplaced, (String)"*", (String)".*")));
            }
        }
    }

    public Collection<FileAnnotation> parse(File file, String moduleName) throws InvocationTargetException {
        try {
            ArrayList<String> sources = new ArrayList<String>(this.mavenSources);
            if (sources.isEmpty()) {
                String moduleRoot = StringUtils.substringBefore((String)file.getAbsolutePath().replace('\\', '/'), (String)"/target/");
                sources.add(moduleRoot + "/src/main/java");
                sources.add(moduleRoot + "/src/test/java");
                sources.add(moduleRoot + "/src");
            }
            return this.parse(file, sources, moduleName);
        }
        catch (IOException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SAXException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (DocumentException exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public Collection<FileAnnotation> parse(final File file, Collection<String> sources, String moduleName) throws IOException, DocumentException, SAXException {
        return this.parse(new InputStreamProvider(){

            @Override
            public InputStream getInputStream() throws IOException {
                return new FileInputStream(file);
            }
        }, sources, moduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<FileAnnotation> parse(InputStreamProvider file, Collection<String> sources, String moduleName) throws IOException, DocumentException, SAXException {
        InputStream input = null;
        try {
            input = file.getInputStream();
            HashMap<String, String> hashToMessageMapping = new HashMap<String, String>();
            HashMap<String, String> categories = new HashMap<String, String>();
            for (XmlBugInstance bug : this.preParse(input)) {
                hashToMessageMapping.put(bug.getInstanceHash(), bug.getMessage());
                categories.put(bug.getType(), bug.getCategory());
            }
            IOUtils.closeQuietly((InputStream)input);
            input = file.getInputStream();
            Collection<FileAnnotation> collection = this.parse(input, sources, moduleName, hashToMessageMapping, categories);
            return collection;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    List<XmlBugInstance> preParse(InputStream file) throws SAXException, IOException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setClassLoader(FindBugsParser.class.getClassLoader());
        String rootXPath = "BugCollection/BugInstance";
        digester.addObjectCreate(rootXPath, XmlBugInstance.class);
        digester.addSetProperties(rootXPath);
        String fileXPath = rootXPath + "/LongMessage";
        digester.addCallMethod(fileXPath, "setMessage", 0);
        digester.addSetNext(rootXPath, "add", Object.class.getName());
        ArrayList<XmlBugInstance> bugs = new ArrayList<XmlBugInstance>();
        digester.push(bugs);
        digester.parse(file);
        return bugs;
    }

    private Collection<FileAnnotation> parse(InputStream file, Collection<String> sources, String moduleName, Map<String, String> hashToMessageMapping, Map<String, String> categories) throws IOException, DocumentException {
        SortedBugCollection collection = this.readXml(file);
        Project project = collection.getProject();
        for (String sourceFolder : sources) {
            project.addSourceDir(sourceFolder);
        }
        SourceFinder sourceFinder = new SourceFinder(project);
        String actualName = this.extractModuleName(moduleName, project);
        TreeStringBuilder stringPool = new TreeStringBuilder();
        ArrayList<FileAnnotation> annotations = new ArrayList<FileAnnotation>();
        Collection bugs = collection.getCollection();
        for (BugInstance warning : bugs) {
            String category;
            SourceLineAnnotation sourceLine = warning.getPrimarySourceLineAnnotation();
            String message = warning.getMessage();
            String type = warning.getType();
            if (message.contains("TEST: Unknown")) {
                message = FindBugsMessages.getInstance().getShortMessage(type, LocaleProvider.getLocale());
            }
            if ((category = categories.get(type)) == null) {
                category = warning.getBugPattern().getCategory();
            }
            Bug bug = new Bug(this.getPriority(warning), StringUtils.defaultIfEmpty((String)hashToMessageMapping.get(warning.getInstanceHash()), (String)message), category, type, sourceLine.getStartLine(), sourceLine.getEndLine());
            bug.setInstanceHash(warning.getInstanceHash());
            bug.setRank(warning.getBugRank());
            boolean ignore = this.setCloudInformation(collection, warning, bug);
            if (ignore) continue;
            bug.setNotAProblem(false);
            bug.setFileName(this.findSourceFile(project, sourceFinder, sourceLine));
            bug.setPackageName(warning.getPrimaryClass().getPackageName());
            bug.setModuleName(actualName);
            this.setAffectedLines(warning, bug);
            annotations.add((FileAnnotation)bug);
            bug.intern(stringPool);
        }
        return this.applyFilters(annotations);
    }

    private List<FileAnnotation> applyFilters(List<FileAnnotation> allAnnotations) {
        List<FileAnnotation> includedAnnotations;
        if (this.includePatterns.isEmpty()) {
            includedAnnotations = allAnnotations;
        } else {
            includedAnnotations = new ArrayList<FileAnnotation>();
            for (FileAnnotation annotation : allAnnotations) {
                for (Pattern include : this.includePatterns) {
                    if (!include.matcher(annotation.getFileName()).matches()) continue;
                    includedAnnotations.add(annotation);
                }
            }
        }
        if (this.excludePatterns.isEmpty()) {
            return includedAnnotations;
        }
        ArrayList<FileAnnotation> excludedAnnotations = new ArrayList<FileAnnotation>(includedAnnotations);
        for (FileAnnotation annotation : includedAnnotations) {
            for (Pattern exclude : this.excludePatterns) {
                if (!exclude.matcher(annotation.getFileName()).matches()) continue;
                excludedAnnotations.remove(annotation);
            }
        }
        return excludedAnnotations;
    }

    private Priority getPriority(BugInstance warning) {
        if (this.isRankActivated) {
            return this.getPriorityByRank(warning);
        }
        return this.getPriorityByPriority(warning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedBugCollection readXml(InputStream file) throws IOException, DocumentException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(FindBugsParser.class.getClassLoader());
            SortedBugCollection collection = new SortedBugCollection();
            collection.readXML(file);
            SortedBugCollection sortedBugCollection = collection;
            return sortedBugCollection;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    @SuppressFBWarnings(value={"NP"})
    private boolean setCloudInformation(SortedBugCollection collection, BugInstance warning, Bug bug) {
        Cloud cloud = collection.getCloud();
        cloud.waitUntilIssueDataDownloaded();
        bug.setShouldBeInCloud(cloud.isOnlineCloud());
        Map cloudDetails = collection.getXmlCloudDetails();
        bug.setDetailsUrlTemplate((String)cloudDetails.get(CLOUD_DETAILS_URL_PROPERTY));
        long firstSeen = cloud.getFirstSeen(warning);
        bug.setInCloud(cloud.isInCloud(warning));
        bug.setFirstSeen(firstSeen);
        int ageInDays = (int)((collection.getAnalysisTimestamp() - firstSeen) / 86400000L);
        bug.setAgeInDays(ageInDays);
        bug.setReviewCount(cloud.getNumberReviewers(warning));
        return cloud.overallClassificationIsNotAProblem(warning);
    }

    private void setAffectedLines(BugInstance warning, Bug bug) {
        Iterator annotationIterator = warning.annotationIterator();
        while (annotationIterator.hasNext()) {
            BugAnnotation bugAnnotation = (BugAnnotation)annotationIterator.next();
            if (!(bugAnnotation instanceof SourceLineAnnotation)) continue;
            SourceLineAnnotation annotation = (SourceLineAnnotation)bugAnnotation;
            bug.addLineRange(new LineRange(annotation.getStartLine(), annotation.getEndLine()));
        }
    }

    private String findSourceFile(Project project, SourceFinder sourceFinder, SourceLineAnnotation sourceLine) {
        try {
            SourceFile sourceFile = sourceFinder.findSourceFile(sourceLine);
            return sourceFile.getFullFileName();
        }
        catch (IOException exception) {
            StringBuilder sb = new StringBuilder("Can't resolve absolute file name for file ");
            sb.append(sourceLine.getSourceFile());
            if (this.isFirstError) {
                sb.append(", dir list = ");
                sb.append(project.getSourceDirList());
                this.isFirstError = false;
            }
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sb.toString());
            return sourceLine.getPackageName().replace(DOT, SLASH) + SLASH + sourceLine.getSourceFile();
        }
    }

    private Priority getPriorityByRank(BugInstance warning) {
        int rank = warning.getBugRank();
        if (rank <= 4) {
            return Priority.HIGH;
        }
        if (rank <= 9) {
            return Priority.NORMAL;
        }
        return Priority.LOW;
    }

    private Priority getPriorityByPriority(BugInstance warning) {
        switch (warning.getPriority()) {
            case 1: {
                return Priority.HIGH;
            }
            case 2: {
                return Priority.NORMAL;
            }
        }
        return Priority.LOW;
    }

    private String extractModuleName(String defaultName, Project project) {
        if (StringUtils.isBlank((String)project.getProjectName())) {
            return defaultName;
        }
        return project.getProjectName();
    }

    static interface InputStreamProvider {
        public InputStream getInputStream() throws IOException;
    }
}

