/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.ebs;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import hudson.model.Hudson;
import hudson.model.PeriodicWork;
import hudson.plugins.ec2.ebs.ZPoolExpandNotice;
import hudson.util.TimeUnit2;
import java.io.IOException;
import java.net.URL;
import org.jvnet.solaris.libzfs.LibZFS;
import org.jvnet.solaris.libzfs.ZFSFileSystem;
import org.jvnet.solaris.libzfs.ZFSPool;

@Extension
public class ZPoolMonitor
extends PeriodicWork {
    private static Boolean isInsideEC2;

    public long getRecurrencePeriod() {
        return TimeUnit2.HOURS.toMillis(1L);
    }

    protected void doRun() {
        ZFSFileSystem fs = null;
        try {
            if (ZPoolMonitor.isInsideEC2()) {
                fs = new LibZFS().getFileSystemByMountPoint(Hudson.getInstance().getRootDir());
            }
        }
        catch (LinkageError e) {
            // empty catch block
        }
        if (fs == null) {
            this.cancel();
            return;
        }
        ZFSPool pool = fs.getPool();
        long a = pool.getAvailableSize();
        long t = pool.getSize();
        ZPoolExpandNotice zen = (ZPoolExpandNotice)((Object)AdministrativeMonitor.all().get(ZPoolExpandNotice.class));
        zen.activated = t / a > 10L && a < 1000000000L;
    }

    public static synchronized boolean isInsideEC2() {
        if (isInsideEC2 == null) {
            try {
                new URL("http://169.254.169.254/latest").openStream().close();
                isInsideEC2 = true;
            }
            catch (IOException e) {
                isInsideEC2 = false;
            }
        }
        return isInsideEC2;
    }
}

