/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.ec2.Jec2;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.EC2RetentionStrategy;
import hudson.plugins.ec2.ssh.EC2UnixLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EC2Slave
extends Slave {
    public final String initScript;
    public final String remoteAdmin;
    public final String rootCommandPrefix;
    private static final Logger LOGGER = Logger.getLogger(EC2Slave.class.getName());

    public EC2Slave(String instanceId, String description, String remoteFS, int numExecutors, String labelString, String initScript, String remoteAdmin, String rootCommandPrefix) throws Descriptor.FormException, IOException {
        this(instanceId, description, remoteFS, numExecutors, Node.Mode.NORMAL, labelString, initScript, Collections.emptyList(), remoteAdmin, rootCommandPrefix);
    }

    @DataBoundConstructor
    public EC2Slave(String instanceId, String description, String remoteFS, int numExecutors, Node.Mode mode, String labelString, String initScript, List<? extends NodeProperty<?>> nodeProperties, String remoteAdmin, String rootCommandPrefix) throws Descriptor.FormException, IOException {
        super(instanceId, description, remoteFS, numExecutors, mode, labelString, (ComputerLauncher)new EC2UnixLauncher(), (RetentionStrategy)new EC2RetentionStrategy(), nodeProperties);
        this.initScript = initScript;
        this.remoteAdmin = remoteAdmin;
        this.rootCommandPrefix = rootCommandPrefix;
    }

    public EC2Slave(String instanceId) throws Descriptor.FormException, IOException {
        this(instanceId, "debug", "/tmp/hudson", 1, Node.Mode.NORMAL, "debug", "", Collections.emptyList(), null, null);
    }

    static int toNumExecutors(InstanceType it) {
        switch (it) {
            case DEFAULT: {
                return 1;
            }
            case MEDIUM_HCPU: {
                return 5;
            }
            case LARGE: {
                return 4;
            }
            case XLARGE: {
                return 8;
            }
            case XLARGE_HCPU: {
                return 20;
            }
        }
        throw new AssertionError();
    }

    public String getInstanceId() {
        return this.getNodeName();
    }

    public Computer createComputer() {
        return new EC2Computer(this);
    }

    public void terminate() {
        try {
            Jec2 ec2 = EC2Cloud.get().connect();
            ec2.terminateInstances(Collections.singletonList(this.getInstanceId()));
            LOGGER.info("Terminated EC2 instance: " + this.getInstanceId());
            Hudson.getInstance().removeNode((Node)this);
        }
        catch (EC2Exception e) {
            LOGGER.log(Level.WARNING, "Failed to terminate EC2 instance: " + this.getInstanceId(), e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to terminate EC2 instance: " + this.getInstanceId(), e);
        }
    }

    String getRemoteAdmin() {
        if (this.remoteAdmin == null || this.remoteAdmin.length() == 0) {
            return "root";
        }
        return this.remoteAdmin;
    }

    String getRootCommandPrefix() {
        if (this.rootCommandPrefix == null || this.rootCommandPrefix.length() == 0) {
            return "";
        }
        return this.rootCommandPrefix + " ";
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "Amazon EC2";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

