/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.ReservationDescription;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2Computer;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.PrintStream;
import org.jets3t.service.S3ServiceException;

public abstract class EC2ComputerLauncher
extends ComputerLauncher {
    public void launch(SlaveComputer _computer, TaskListener listener) {
        try {
            EC2Computer computer = (EC2Computer)_computer;
            PrintStream logger = listener.getLogger();
            block10: while (true) {
                switch (computer.getState()) {
                    case PENDING: {
                        Thread.sleep(5000L);
                        continue block10;
                    }
                    case RUNNING: {
                        break block10;
                    }
                    case SHUTTING_DOWN: 
                    case TERMINATED: {
                        logger.println("The instance " + computer.getInstanceId() + " appears to be shut down. Aborting launch.");
                        return;
                    }
                    default: {
                        continue block10;
                    }
                }
                break;
            }
            this.launch(computer, logger, computer.describeInstance());
        }
        catch (EC2Exception e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        catch (IOException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        catch (S3ServiceException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
    }

    protected abstract void launch(EC2Computer var1, PrintStream var2, ReservationDescription.Instance var3) throws EC2Exception, IOException, InterruptedException, S3ServiceException;
}

