/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.plugins.claim.ClaimTestAction;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestAction;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestObject;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClaimTestDataPublisher
extends TestDataPublisher {
    @DataBoundConstructor
    public ClaimTestDataPublisher() {
    }

    public Data getTestData(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, TestResult testResult) {
        Data data = new Data(build);
        for (CaseResult result : testResult.getFailedTests()) {
            ClaimTestAction previousAction;
            CaseResult previous = result.getPreviousResult();
            if (previous == null || (previousAction = (ClaimTestAction)((Object)previous.getTestAction(ClaimTestAction.class))) == null || !previousAction.isClaimed() || !previousAction.isSticky()) continue;
            ClaimTestAction action = new ClaimTestAction(data, result.getId());
            previousAction.copyTo(action);
            data.addClaim(result.getId(), action);
        }
        return data;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<TestDataPublisher> {
        public String getDisplayName() {
            return "Allow claiming of failed tests";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Data
    extends TestResultAction.Data
    implements Saveable {
        private Map<String, ClaimTestAction> claims = new HashMap<String, ClaimTestAction>();
        private final AbstractBuild<?, ?> build;

        public Data(AbstractBuild<?, ?> build) {
            this.build = build;
        }

        public List<TestAction> getTestAction(TestObject testObject) {
            CaseResult cr;
            String id = testObject.getId();
            ClaimTestAction result = this.claims.get(id);
            if (result == null && id.startsWith("junit")) {
                result = this.claims.get(id.substring(5));
            }
            if (result != null) {
                return Collections.singletonList(result);
            }
            if (testObject instanceof CaseResult && !(cr = (CaseResult)testObject).isPassed() && !cr.isSkipped()) {
                return Collections.singletonList(new ClaimTestAction(this, id));
            }
            return Collections.emptyList();
        }

        public void save() throws IOException {
            this.build.save();
        }

        public void addClaim(String testObjectId, ClaimTestAction claim) {
            this.claims.put(testObjectId, claim);
        }
    }
}

