/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.claim.ClaimBuildAction;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClaimPublisher
extends Notifier {
    @DataBoundConstructor
    public ClaimPublisher() {
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().isWorseThan(Result.SUCCESS)) {
            ClaimBuildAction c;
            ClaimBuildAction action = new ClaimBuildAction((Run)build);
            build.addAction((Action)action);
            AbstractBuild previousBuild = (AbstractBuild)build.getPreviousBuild();
            if (previousBuild != null && (c = (ClaimBuildAction)previousBuild.getAction(ClaimBuildAction.class)) != null && c.isClaimed() && c.isSticky()) {
                c.copyTo(action);
            }
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getHelpFile() {
            return "/plugin/claim/help.html";
        }

        public String getDisplayName() {
            return "Allow broken build claiming";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

