/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.marshal.xref;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.AbstractReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.IOException;
import java.lang.ref.SoftReference;
import org.hudsonci.utils.marshal.xref.XReference;

public abstract class XReferenceConverter
extends AbstractReflectionConverter {
    protected HolderType holderType = HolderType.HARD;

    public XReferenceConverter(Mapper mapper, ReflectionProvider reflection) {
        super(mapper, reflection);
    }

    public HolderType getHolderType() {
        return this.holderType;
    }

    public void setHolderType(HolderType type) {
        this.holderType = (HolderType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
    }

    public boolean canConvert(Class type) {
        return XReference.class.isAssignableFrom(type);
    }

    protected void doMarshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        super.doMarshal(source, writer, context);
        XReference ref = (XReference)source;
        Object target = ref.get();
        if (target != null) {
            try {
                this.store(ref);
                ref.holder = this.createStoredHolder(ref, target);
            }
            catch (Exception e) {
                throw new ConversionException("Failed to marshal reference: " + ref, (Throwable)e);
            }
        }
    }

    public Object doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
        XReference ref = (XReference)super.doUnmarshal(result, reader, context);
        ref.holder = this.createUnmarshalHolder(ref);
        return ref;
    }

    protected abstract void store(XReference var1) throws IOException;

    protected abstract Object load(XReference var1) throws IOException;

    protected XReference.Holder createStoredHolder(XReference ref, Object target) {
        switch (this.holderType) {
            case HARD: {
                return new XReference.InstanceHolder<Object>(target);
            }
            case SOFT: {
                return new SoftUnmarshalHolder(ref, target);
            }
        }
        throw new Error();
    }

    protected XReference.Holder createUnmarshalHolder(XReference ref) {
        switch (this.holderType) {
            case HARD: {
                return new UnmarshalHolder(ref);
            }
            case SOFT: {
                return new SoftUnmarshalHolder(ref);
            }
        }
        throw new Error();
    }

    protected class SoftUnmarshalHolder
    extends HolderSupport {
        protected SoftReference instance;

        protected SoftUnmarshalHolder(XReference ref) {
            super(ref);
        }

        protected SoftUnmarshalHolder(XReference ref, Object target) {
            super(ref);
            Preconditions.checkNotNull((Object)target);
            this.instance = new SoftReference<Object>(target);
        }

        public Object get() {
            Object target;
            if (this.instance == null || (target = this.instance.get()) == null) {
                target = this.doLoad();
                this.instance = new SoftReference<Object>(target);
            }
            return target;
        }

        public String toString() {
            return "SoftUnmarshalHolder{instance=" + this.instance + '}';
        }
    }

    protected class UnmarshalHolder
    extends HolderSupport {
        protected Object instance;

        protected UnmarshalHolder(XReference ref) {
            super(ref);
        }

        public Object get() {
            if (this.instance == null) {
                this.instance = this.doLoad();
            }
            return this.instance;
        }

        public String toString() {
            return "UnmarshalHolder{instance=" + this.instance + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HolderType {
        HARD,
        SOFT;

    }

    protected abstract class HolderSupport
    implements XReference.Holder {
        protected final XReference ref;

        protected HolderSupport(XReference ref) {
            this.ref = (XReference)Preconditions.checkNotNull((Object)ref);
        }

        protected Object doLoad() {
            try {
                return XReferenceConverter.this.load(this.ref);
            }
            catch (Exception e) {
                throw new ConversionException("Failed to unmarshal reference: " + this.ref, (Throwable)e);
            }
        }
    }
}

