/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.io;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class FileUtil {
    public static File canonicalize(File file) {
        Preconditions.checkNotNull((Object)file);
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL getResource(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource);
    }

    public static File getResourceAsFile(String resource) {
        return new File(FileUtil.getResource(resource).getFile());
    }

    public static File getResourceAsFile(Class clazz, String resource) {
        return new File(clazz.getResource(resource).getFile());
    }

    public static InputStream getResourceAsStream(String resource) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
    }

    public static InputStream getResourceAsStream(Class clazz, String resource) {
        return clazz.getClassLoader().getResourceAsStream(resource);
    }
}

