/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.hamcrest;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLRespondsWithStatusMatcher
extends TypeSafeMatcher<URL> {
    private int statusCode = -2;
    private int timeout = 0;
    private int receivedStatusCode = 0;
    private boolean timedOut = false;
    private Exception e;
    private String urlString;

    public URLRespondsWithStatusMatcher(int statusCode) {
        this(statusCode, 0);
    }

    public URLRespondsWithStatusMatcher(int statusCode, int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout cannot be negative");
        }
        if (statusCode < -1) {
            throw new IllegalArgumentException("status code cannot be less than negative one");
        }
        this.statusCode = statusCode;
        this.timeout = timeout;
    }

    public void describeTo(Description description) {
        if (this.timedOut) {
            description.appendValue((Object)this.urlString).appendText(" to connect within ").appendValue((Object)this.timeout).appendText("ms");
        } else if (this.e != null) {
            description.appendValue((Object)this.urlString).appendText(" to successfully connect");
        } else {
            description.appendValue((Object)this.urlString).appendText(" to respond with ").appendValue((Object)this.statusCode);
        }
    }

    protected void describeMismatchSafely(URL item, Description mismatchDescription) {
        if (this.timedOut) {
            mismatchDescription.appendText("took longer.");
            if (this.e != null) {
                mismatchDescription.appendText(this.e.getMessage());
            }
        } else if (this.e != null) {
            mismatchDescription.appendText("got ").appendValue((Object)this.e);
        } else {
            mismatchDescription.appendText("was ").appendValue((Object)this.receivedStatusCode);
        }
    }

    protected boolean matchesSafely(URL item) {
        this.urlString = item.toString();
        try {
            URL url = new URL(item.toString());
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            if (this.timeout > -1) {
                urlConnection.setConnectTimeout(this.timeout);
                urlConnection.setReadTimeout(this.timeout);
            }
            urlConnection.setUseCaches(false);
            urlConnection.connect();
            this.receivedStatusCode = urlConnection.getResponseCode();
        }
        catch (SocketTimeoutException ste) {
            this.timedOut = true;
            this.e = ste;
        }
        catch (IOException ioe) {
            this.e = ioe;
        }
        catch (Exception e) {
            this.e = e;
        }
        return !this.timedOut && this.e == null && this.receivedStatusCode == this.statusCode;
    }
}

