/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.test;

import com.google.common.base.Preconditions;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtil {
    private final Class owningClass;
    protected final File baseDir;
    protected final Logger log;

    public TestUtil(Class owner) {
        if (null == owner) {
            throw new IllegalArgumentException("owner is required");
        }
        this.owningClass = owner;
        this.baseDir = this.initBaseDir();
        this.log = LoggerFactory.getLogger((Class)owner);
    }

    public TestUtil(Object owner) {
        this(owner.getClass());
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public Logger getLog() {
        return this.log;
    }

    protected final File initBaseDir() {
        File dir;
        String tmp = System.getProperty("basedir");
        if (tmp != null) {
            dir = new File(tmp);
        } else {
            String path = this.owningClass.getProtectionDomain().getCodeSource().getLocation().getFile();
            dir = new File(path).getParentFile().getParentFile();
            System.setProperty("basedir", dir.getPath());
        }
        return dir;
    }

    public final File resolveFile(String path) {
        Preconditions.checkNotNull((Object)path);
        File file = new File(path);
        if (file.isAbsolute()) {
            this.log.warn("Given path is already absolute; nothing to resolve: {}", (Object)file);
        } else {
            file = new File(this.baseDir, path);
        }
        return file;
    }

    public final String resolvePath(String path) {
        Preconditions.checkNotNull((Object)path);
        return this.resolveFile(path).getPath();
    }
}

