/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.junit.ext;

import com.googlecode.junit.ext.checkers.Checker;
import java.net.MalformedURLException;
import java.net.URL;
import org.hamcrest.MatcherAssert;
import org.hudsonci.utils.hamcrest.URLMatchers;

public class URLIsReachable
implements Checker {
    private URL url;
    private int timeout = 10000;
    private int statusCode = 200;
    private String message = "";

    public URLIsReachable(String urlString) throws MalformedURLException {
        String[] args = new String[]{urlString};
        this.init(args);
    }

    public URLIsReachable(String[] args) throws MalformedURLException {
        this.init(args);
    }

    private void init(String[] args) throws MalformedURLException {
        this.url = new URL(args[0]);
        if (args.length >= 2) {
            this.timeout = Integer.parseInt(args[1]);
        }
        if (args.length >= 3) {
            this.statusCode = Integer.parseInt(args[2]);
        }
        if (args.length == 4) {
            this.message = args[3];
        }
    }

    public boolean satisfy() {
        try {
            MatcherAssert.assertThat((Object)this.url, URLMatchers.respondsWithStatusWithin(this.statusCode, this.timeout));
        }
        catch (AssertionError ae) {
            System.err.println("[WARN] " + String.format("%s caused a test to be ignored %s, %s", this.getClass().getSimpleName(), this.message, ((Throwable)((Object)ae)).getMessage()));
            return false;
        }
        return true;
    }
}

