/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.FilePath;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class TemporaryDirectoryAllocator {
    private final Set<File> tmpDirectories = new HashSet<File>();
    private final File base;

    public TemporaryDirectoryAllocator(File base) {
        this.base = base;
    }

    public TemporaryDirectoryAllocator() {
        this(new File(System.getProperty("java.io.tmpdir")));
    }

    public synchronized File allocate() throws IOException {
        try {
            File f = File.createTempFile("hudson", "test", this.base);
            f.delete();
            f.mkdirs();
            this.tmpDirectories.add(f);
            return f;
        }
        catch (IOException e) {
            throw new IOException2("Failed to create a temporary directory in " + this.base, (Throwable)e);
        }
    }

    public synchronized void dispose() throws IOException, InterruptedException {
        Object x = null;
        for (File dir : this.tmpDirectories) {
            try {
                new FilePath(dir).deleteRecursive();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.tmpDirectories.clear();
    }

    public synchronized void disposeAsync() {
        final HashSet<File> tbr = new HashSet<File>(this.tmpDirectories);
        this.tmpDirectories.clear();
        new Thread("Disposing " + this.base){

            public void run() {
                for (File dir : tbr) {
                    try {
                        new FilePath(dir).deleteRecursive();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }
}

