/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.tasks;

import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.RemoteInputStream;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.SocketInputStream;
import hudson.remoting.SocketOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenServerSocket
implements Callable<Acceptor, IOException> {
    private static final Logger log = LoggerFactory.getLogger(OpenServerSocket.class);
    public static final int DEFAULT_SO_TIMEOUT = 30000;

    public Acceptor call() throws IOException {
        return new AcceptorImpl();
    }

    protected void customize(ServerSocket serverSocket) throws SocketException {
        assert (serverSocket != null);
        serverSocket.setSoTimeout(30000);
    }

    private class ConnectionImpl
    implements Connection,
    Serializable {
        private static final long serialVersionUID = 1L;
        private InputStream input;
        private OutputStream output;

        public ConnectionImpl(InputStream input, OutputStream output) {
            assert (input != null);
            this.input = input;
            assert (output != null);
            this.output = output;
            log.debug("Created connection");
        }

        private ConnectionImpl(Socket socket) throws IOException {
            this((InputStream)new SocketInputStream(socket), (OutputStream)new SocketOutputStream(socket));
        }

        public InputStream getInput() {
            return this.input;
        }

        public OutputStream getOutput() {
            return this.output;
        }

        public void close() throws IOException {
        }

        private Object writeReplace() {
            return new ConnectionImpl((InputStream)new RemoteInputStream(this.input), (OutputStream)new RemoteOutputStream(this.output));
        }

        private Object readResolve() {
            this.input = new BufferedInputStream(this.input);
            this.output = new BufferedOutputStream(this.output);
            return this;
        }
    }

    private class AcceptorImpl
    implements Acceptor,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final transient ServerSocket serverSocket = new ServerSocket();

        public AcceptorImpl() throws IOException {
            this.serverSocket.bind(null);
            OpenServerSocket.this.customize(this.serverSocket);
            log.debug("Created acceptor");
        }

        public Connection accept(boolean close) throws IOException {
            log.debug("Accepting");
            Socket socket = this.serverSocket.accept();
            log.debug("Accepted: {}", (Object)socket);
            if (close) {
                this.close();
            }
            return new ConnectionImpl(socket);
        }

        public Connection accept() throws IOException {
            return this.accept(false);
        }

        public void close() throws IOException {
            log.debug("Closing");
            this.serverSocket.close();
        }

        public int getPort() {
            return this.serverSocket.getLocalPort();
        }

        private Object writeReplace() {
            return Channel.current().export(Acceptor.class, (Object)this);
        }
    }

    public static interface Connection
    extends Closeable {
        public InputStream getInput();

        public OutputStream getOutput();
    }

    public static interface Acceptor
    extends Closeable {
        public int getPort();

        public Connection accept(boolean var1) throws IOException;

        public Connection accept() throws IOException;
    }
}

