/*
 * Decompiled with CFR 0.152.
 */
package com4j.tlbimp.driver;

import com4j.ComException;
import com4j.GUID;
import com4j.tlbimp.BindingException;
import com4j.tlbimp.CodeWriter;
import com4j.tlbimp.DumpCodeWriter;
import com4j.tlbimp.ErrorListener;
import com4j.tlbimp.FileCodeWriter;
import com4j.tlbimp.TypeLibInfo;
import com4j.tlbimp.def.IWTypeLib;
import com4j.tlbimp.driver.Driver;
import com4j.tlbimp.driver.Lib;
import com4j.tlbimp.driver.Messages;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Main
implements ErrorListener {
    @Option(name="-o")
    public File outDir = new File("-");
    @Option(name="-p")
    public String packageName = "";
    @Option(name="-debug")
    public boolean debug;
    @Option(name="-v")
    public boolean verbose;
    @Option(name="-libid")
    public String libid = null;
    @Option(name="-libver")
    public String libVersion = null;
    @Option(name="-locale")
    public String locale = null;
    @Option(name="-javaGetterSetterName", usage="Generate getters/setters in the Java naming convention")
    public boolean javaGetterSetterName = false;
    @Option(name="-alwaysUseComEnums", usage="Always use ComEnum for generating enums")
    public boolean alwaysUseComEnums = false;
    @Argument
    private List<String> files = new ArrayList<String>();

    public static void main(String[] args) {
        System.exit(new Main().doMain(args));
    }

    private void usage() {
        System.err.println((Object)Messages.USAGE);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doMain(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException cmdLineException) {
            System.err.println(cmdLineException.getMessage());
            this.usage();
            return -1;
        }
        if (this.libid != null) {
            if (!this.files.isEmpty()) {
                System.err.println((Object)Messages.CANT_SPECIFY_LIBID_AND_FILENAME);
                this.usage();
                return -1;
            }
            try {
                TypeLibInfo typeLibInfo = TypeLibInfo.locate(new GUID(this.libid), this.libVersion);
                if (this.verbose) {
                    System.err.printf("Found %1s <%2s>\n", typeLibInfo.libName, typeLibInfo.version);
                }
                this.files = Arrays.asList(typeLibInfo.typeLibrary.toString());
            }
            catch (BindingException bindingException) {
                this.error(bindingException);
                return -1;
            }
        } else if (this.files.size() < 1) {
            System.err.println((Object)Messages.NO_FILE_NAME);
            this.usage();
            return -1;
        }
        if (this.outDir.getPath().equals("-")) {
            if (!this.debug) {
                System.err.println((Object)Messages.NO_OUTPUT_DIR);
                this.usage();
                return -1;
            }
            DumpCodeWriter dumpCodeWriter = new DumpCodeWriter();
        } else {
            FileCodeWriter fileCodeWriter = new FileCodeWriter(this.outDir);
        }
        Driver driver = new Driver();
        driver.setPackageName(this.packageName);
        for (String file : this.files) {
            File typeLibFileName = new File(file);
            if (!typeLibFileName.exists()) {
                System.err.println(Messages.NO_SUCH_FILE.format(typeLibFileName));
                return -1;
            }
            Lib lib = new Lib();
            lib.setFile(typeLibFileName);
            driver.addLib(lib);
        }
        driver.alwaysUseComEnums = this.alwaysUseComEnums;
        driver.renameGetterAndSetters = this.javaGetterSetterName;
        try {
            void var3_8;
            if (this.locale != null) {
                driver.setLocale(this.locale);
            }
            driver.run((CodeWriter)var3_8, this);
            return 0;
        }
        catch (ComException e) {
            return this.handleException((Exception)((Object)e));
        }
        catch (IOException e) {
            return this.handleException(e);
        }
        catch (BindingException e) {
            return this.handleException(e);
        }
    }

    private int handleException(Exception e) {
        if (this.debug) {
            e.printStackTrace(System.err);
            return 1;
        }
        System.err.println(e.getMessage());
        return 1;
    }

    public void started(IWTypeLib lib) {
        System.err.println("Generating definitions from " + lib.getName());
    }

    public void error(BindingException e) {
        this.handleException(e);
    }

    public void warning(String message) {
        System.err.println(message);
    }
}

